/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.emf.ui;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.internal.JDTUtil;
import org.eclipse.xtend.shared.ui.core.internal.ResourceID;
import org.eclipse.xtend.typesystem.emf.ui.BuildJob;
import org.eclipse.xtend.typesystem.emf.ui.EmfToolsPlugin;
import org.eclipse.xtend.typesystem.emf.ui.Messages;
import org.eclipse.xtend.typesystem.emf.ui.internal.EmfToolsLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProjectAnalyzer
extends Job {
    private final IJavaProject project;
    private ResourceSet rs;
    private Map<IStorage, Resource> mapping;
    private Map<String, EPackage> packages;

    public ProjectAnalyzer(IJavaProject project) {
        super(String.valueOf(Messages.ProjectAnalyzer_AnalysingPrompt) + project.getProject().getProject().getName());
        this.setRule((ISchedulingRule)project.getProject().getWorkspace().getRoot());
        this.project = project;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (EmfToolsPlugin.trace) {
            System.out.println(String.valueOf(Messages.ProjectAnalyzer_1) + this.project.getProject().getProject().getName());
        }
        this.rs = ConverterUtil.createResourceSet();
        this.mapping = new HashMap<IStorage, Resource>();
        this.packages = new HashMap<String, EPackage>();
        this.loadMetamodelsForProject(this.project, this.rs, monitor);
        this.packages.put("http://www.eclipse.org/emf/2002/Ecore", (EPackage)EcorePackage.eINSTANCE);
        EPackageRegistryImpl registry = new EPackageRegistryImpl(this.rs.getPackageRegistry());
        registry.putAll(this.packages);
        this.rs.setPackageRegistry((EPackage.Registry)registry);
        if (Activator.getExtXptModelManager().findProject((IResource)this.project.getProject()) != null) {
            new BuildJob(this.project.getProject(), null).schedule();
        }
        return Status.OK_STATUS;
    }

    private void loadMetamodelsForProject(IJavaProject javaProject, final ResourceSet rs, IProgressMonitor monitor) {
        try {
            final String ext = Messages.ProjectAnalyzer_2;
            if (!javaProject.exists()) {
                return;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                block19: {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (!root.isArchive()) {
                        IResource rootResource = null;
                        rootResource = root instanceof ExternalPackageFragmentRoot ? ((ExternalPackageFragmentRoot)root).resource() : root.getUnderlyingResource();
                        if (rootResource != null) {
                            try {
                                if (!rootResource.exists() || !rootResource.isAccessible()) {
                                    rootResource.refreshLocal(2, monitor);
                                }
                                rootResource.accept(new IResourceVisitor(){

                                    public boolean visit(IResource resource) throws CoreException {
                                        if (resource instanceof IFile && ext.equals(((IFile)resource).getFileExtension())) {
                                            ProjectAnalyzer.this.loadModelFromStorage(rs, (IStorage)((IFile)resource));
                                        }
                                        return true;
                                    }
                                });
                            }
                            catch (CoreException e) {
                                EmfToolsLog.logError(e);
                            }
                        }
                    } else if (((JarPackageFragmentRoot)root).getPath().toString().contains(Messages.ProjectAnalyzer_3)) {
                        if (EmfToolsPlugin.trace) {
                            System.out.println(String.valueOf(Messages.ProjectAnalyzer_4) + ((JarPackageFragmentRoot)root).getPath().toString());
                        }
                    } else {
                        root.open(monitor);
                        try {
                            try {
                                ZipFile zip = ((JarPackageFragmentRoot)root).getJar();
                                Enumeration<? extends ZipEntry> entries = zip.entries();
                                while (entries.hasMoreElements()) {
                                    String fqn;
                                    ResourceID resourceID;
                                    IStorage findStorage;
                                    ZipEntry entry = entries.nextElement();
                                    String name = entry.getName();
                                    if (!name.endsWith(ext) || (findStorage = JDTUtil.loadFromJar((ResourceID)(resourceID = new ResourceID(fqn = name.substring(0, name.length() - ext.length() - 1).replaceAll(Messages.ProjectAnalyzer_5, Messages.ProjectAnalyzer_6), ext)), (IPackageFragmentRoot)root)) == null) continue;
                                    this.loadModelFromStorage(rs, findStorage);
                                }
                            }
                            catch (CoreException e) {
                                EmfToolsLog.logError(e);
                                root.close();
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            root.close();
                            throw throwable;
                        }
                        root.close();
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            EmfToolsLog.logError(e);
        }
    }

    private void loadModelFromStorage(ResourceSet rs, IStorage storage) {
        Resource r;
        URI uri = URI.createPlatformResourceURI((String)storage.getFullPath().toString(), (boolean)true);
        if (EmfToolsPlugin.trace) {
            System.out.println(String.valueOf(Messages.ProjectAnalyzer_7) + storage.getFullPath().toString());
        }
        if ((r = rs.createResource(uri)).isLoaded() && !r.isModified()) {
            return;
        }
        try {
            r.load(storage.getContents(), Collections.EMPTY_MAP);
            this.mapping.put(storage, r);
            this.registerEPackages(rs, r, false);
        }
        catch (IOException e) {
            EmfToolsLog.logError(String.valueOf(Messages.ProjectAnalyzer_8) + uri, e);
        }
        catch (CoreException e) {
            EmfToolsLog.logError(String.valueOf(Messages.ProjectAnalyzer_9) + uri, e);
        }
        catch (RuntimeException e) {
            EmfToolsLog.logError(String.valueOf(Messages.ProjectAnalyzer_10) + uri, e);
        }
    }

    private void registerEPackages(ResourceSet rs, Resource r, boolean overwrite) {
        Collection packages = EcoreUtil.getObjectsByType((Collection)r.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE);
        for (EPackage pack : packages) {
            this.registerPackage(pack, rs, overwrite);
        }
    }

    private void registerPackage(EPackage pack, ResourceSet rs, boolean overwrite) {
        if (!overwrite && this.packages.containsKey(pack.getNsURI())) {
            if (EmfToolsPlugin.trace) {
                System.out.println(String.valueOf(Messages.ProjectAnalyzer_11) + pack.getName() + Messages.ProjectAnalyzer_12);
            }
        } else {
            this.packages.put(pack.getNsURI(), pack);
        }
        for (EPackage p : pack.getESubpackages()) {
            this.registerPackage(p, rs, overwrite);
        }
    }

    public Map<String, EPackage> getNamedEPackageMap() {
        if (this.packages == null) {
            this.run((IProgressMonitor)new NullProgressMonitor());
        }
        return Collections.unmodifiableMap(this.packages);
    }
}

