/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.builtin;

import java.util.Arrays;
import java.util.List;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.FunctionDefContext;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.types.AbstractType;
import org.eclipse.xtend.backend.types.builtin.ListType;
import org.eclipse.xtend.backend.types.builtin.VoidType;

public final class FunctionType
extends AbstractType {
    public static final FunctionType INSTANCE = new FunctionType();

    private FunctionType() {
        super("Function", "{builtin}Function", new BackendType[0]);
        this.register(new QualifiedName("invoke"), new Function(){

            public List<BackendType> getParameterTypes() {
                return Arrays.asList(INSTANCE, ListType.INSTANCE);
            }

            @Override
            public Object invoke(ExecutionContext ctx, Object[] params) {
                return ctx.getFunctionInvoker().invoke(ctx, (Function)params[0], (List)params[1]);
            }

            @Override
            public boolean isCached() {
                return false;
            }

            @Override
            public ExpressionBase getGuard() {
                return null;
            }

            @Override
            public FunctionDefContext getFunctionDefContext() {
                return null;
            }

            @Override
            public void setFunctionDefContext(FunctionDefContext fdc) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BackendType getReturnType() {
                throw new UnsupportedOperationException();
            }
        });
    }

    public boolean isAssignableFrom(BackendType other) {
        return other == this || other == VoidType.INSTANCE;
    }

    public boolean equals(Object other) {
        return other == this;
    }
}

