/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.xsd.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.Property;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.functions.AbstractFunction;
import org.eclipse.xtend.backend.types.AbstractProperty;
import org.eclipse.xtend.backend.types.AbstractType;
import org.eclipse.xtend.backend.types.builtin.BooleanType;
import org.eclipse.xtend.backend.types.builtin.ListType;
import org.eclipse.xtend.backend.types.builtin.ObjectType;
import org.eclipse.xtend.backend.types.builtin.VoidType;
import org.eclipse.xtend.backend.types.emf.EObjectType;
import org.eclipse.xtend.backend.types.xsd.XsdTypesystem;
import org.eclipse.xtend.backend.types.xsd.internal.EFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EFeatureMapType
extends AbstractType {
    public EFeatureMapType(String name, EClass owner, XsdTypesystem ts) {
        super(name, "{xsd}" + name, Arrays.asList(ListType.INSTANCE));
        for (final EStructuralFeature f : this.getMapFeatures()) {
            this.register((Property)new AbstractProperty((BackendType)this, EStructuralFeature.class, f.getName(), true, f.isChangeable()){

                protected Object getRaw(ExecutionContext ctx, Object target) {
                    if (target == null) {
                        return null;
                    }
                    FeatureMap map = (FeatureMap)target;
                    return map.list(f);
                }

                public BackendType getType(BackendTypesystem ts) {
                    return ts.findType((Object)f);
                }
            }, (BackendType)this);
            this.register(new QualifiedName("add"), (Function)new AbstractFunction(null, Arrays.asList(new BackendType[]{this, new EFeatureType("EFeature", ts), ObjectType.INSTANCE}), (BackendType)BooleanType.INSTANCE, false){

                public Object invoke(ExecutionContext ctx, Object[] params) {
                    FeatureMap map = (FeatureMap)params[0];
                    EStructuralFeature f = (EStructuralFeature)params[1];
                    return map.add(f, params[2]);
                }
            });
            this.register(new QualifiedName("set"), (Function)new AbstractFunction(null, Arrays.asList(new BackendType[]{this, new EFeatureType("EFeature", ts), ObjectType.INSTANCE}), (BackendType)VoidType.INSTANCE, false){

                public Object invoke(ExecutionContext ctx, Object[] params) {
                    FeatureMap map = (FeatureMap)params[0];
                    EStructuralFeature f = (EStructuralFeature)params[1];
                    map.set(f, params[2]);
                    return null;
                }
            });
            this.register(new QualifiedName("unset"), (Function)new AbstractFunction(null, Arrays.asList(new AbstractType[]{this, new EFeatureType("EFeature", ts)}), (BackendType)VoidType.INSTANCE, false){

                public Object invoke(ExecutionContext ctx, Object[] params) {
                    FeatureMap map = (FeatureMap)params[0];
                    EStructuralFeature f = (EStructuralFeature)params[1];
                    map.unset(f);
                    return null;
                }
            });
            this.register(new QualifiedName("isSet"), (Function)new AbstractFunction(null, Arrays.asList(new AbstractType[]{this, new EFeatureType("EFeature", ts)}), (BackendType)BooleanType.INSTANCE, false){

                public Object invoke(ExecutionContext ctx, Object[] params) {
                    FeatureMap map = (FeatureMap)params[0];
                    EStructuralFeature f = (EStructuralFeature)params[1];
                    return map.isSet(f);
                }
            });
            this.register(new QualifiedName("list"), (Function)new AbstractFunction(null, Arrays.asList(this), (BackendType)ListType.INSTANCE, false){

                public Object invoke(ExecutionContext ctx, Object[] params) {
                    FeatureMap map = (FeatureMap)params[0];
                    EStructuralFeature f = (EStructuralFeature)params[1];
                    return map.list(f);
                }
            });
            this.register(new QualifiedName("addAll"), (Function)new AbstractFunction(null, Arrays.asList(this), (BackendType)BooleanType.INSTANCE, false){

                public Object invoke(ExecutionContext ctx, Object[] params) {
                    FeatureMap map = (FeatureMap)params[0];
                    EStructuralFeature f = (EStructuralFeature)params[1];
                    Collection aList = (Collection)params[2];
                    return map.addAll(aList);
                }
            });
            this.register(new QualifiedName("addFrom"), (Function)new AbstractFunction(null, Arrays.asList(new AbstractType[]{this, EObjectType.INSTANCE}), (BackendType)VoidType.INSTANCE, false){

                public Object invoke(ExecutionContext ctx, Object[] params) {
                    FeatureMap map = (FeatureMap)params[0];
                    EStructuralFeature.Setting s = (EStructuralFeature.Setting)map;
                    EObject o = (EObject)params[1];
                    FeatureMapUtil.Validator v = FeatureMapUtil.getValidator((EClass)s.getEObject().eClass(), (EStructuralFeature)s.getEStructuralFeature());
                    for (EStructuralFeature f : o.eClass().getEAllStructuralFeatures()) {
                        if (f.isDerived() || !o.eIsSet(f)) continue;
                        Object val = o.eGet(f);
                        if (val instanceof FeatureMap) {
                            for (FeatureMap.Entry e : new ArrayList((FeatureMap)val)) {
                                if (!v.isValid(e.getEStructuralFeature())) continue;
                                this.add(map, e.getEStructuralFeature(), e.getValue());
                            }
                            continue;
                        }
                        if (!v.isValid(f)) continue;
                        this.add(map, f, val);
                    }
                    return null;
                }

                private void add(FeatureMap map, EStructuralFeature f, Object val) {
                    if (f.isMany() && val instanceof Collection) {
                        map.addAll(f, (Collection)val);
                    } else {
                        map.add(f, val);
                    }
                }
            });
        }
    }

    protected List<EStructuralFeature> getMapFeatures() {
        return Collections.EMPTY_LIST;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return ((Object)((Object)this)).getClass() == other.getClass();
    }
}

