/*******************************************************************************
 * Copyright (c) 2005, 2007 committers of openArchitectureWare and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     committers of openArchitectureWare - initial API and implementation
 *******************************************************************************/
package org.eclipse.xtend.shared.ui.wizards;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.xtend.shared.ui.Messages;
import org.eclipse.xtend.shared.ui.core.preferences.PreferenceConstants;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

public class XtendXpandProjectWizard extends Wizard implements INewWizard, IExecutableExtension {
	private XtendXpandProjectWizardPage page;

	private IConfigurationElement configElement;

	public XtendXpandProjectWizard() {
		super();
		setNeedsProgressMonitor(true);
	}

	@Override
	public void addPages() {
		page = new XtendXpandProjectWizardPage();
		addPage(page);
	}

	@Override
	public boolean performFinish() {
		final String name = page.getProjectName();
		final boolean genExample = page.isCreateExample(); 
		final boolean projectSpecific = page.isProjectSpecificMM();
		final boolean workspaceDefault = page.isUseWorkspaceDefinedMM();
		final IRunnableWithProgress op = new IRunnableWithProgress() {
			public void run(final IProgressMonitor monitor) throws InvocationTargetException {
				try {
					doFinish(name, genExample, projectSpecific, workspaceDefault, monitor);
				}
				finally {
					monitor.done();
				}
			}
		};
		try {
			getContainer().run(true, false, op);
		}
		catch (final InterruptedException e) {
			return false;
		}
		catch (final InvocationTargetException e) {
			final Throwable realException = e.getTargetException();
			MessageDialog.openError(getShell(), Messages.XtendXpandProjectWizard_ErrorLabel, realException.getMessage());
			return false;
		}
		BasicNewProjectResourceWizard.updatePerspective(configElement);
		return true;
	}

	void doFinish(final String name, final boolean genExamle, final boolean projectSpecific, final boolean workspaceDefaults, final IProgressMonitor monitor) {
		final String projectName = name;
		int ticks = (genExamle == true) ? 15 :6;
		monitor.beginTask(Messages.XtendXpandProjectWizard_ProjectCreationMessage + name, ticks);

		final Set<String> refs = new HashSet<String>();
		final List<String> srcfolders = new ArrayList<String>();
		srcfolders.add("src");
		srcfolders.add("src-gen");

		refs.add("org.eclipse.jdt.core;bundle-version=\"3.5.0\"");
		refs.add("org.apache.commons.logging");
		refs.add("org.apache.log4j;resolution:=optional");
		refs.add("org.eclipse.xtend.profiler;resolution:=optional");
		final IProject p = EclipseHelper.createExtXptProject(projectName, srcfolders, Collections
				.<IProject> emptyList(), refs, null, new SubProgressMonitor(monitor, 3), getShell());

		if (p == null)
			return;
		
		String encoding = ResourcesPlugin.getEncoding();
		EclipseHelper.createFile(".settings/org.eclipse.core.resources.prefs", p,
				"eclipse.preferences.version=1\nencoding/<project>="+encoding+"\n", new NullProgressMonitor());
		monitor.worked(1);
		
		if (genExamle) {
			EclipseHelper.createFile(".settings/org.eclipse.xtend.shared.ui.prefs", p,
					"metamodelContributor=org.eclipse.xtend.typesystem.emf.ui.EmfMetamodelContributor\nproject.specific.metamodel=true\n", new NullProgressMonitor());
			monitor.worked(1);
			EclipseHelper.createFile("src/metamodel/Checks.chk", p, getContents("Checks.chk"), new NullProgressMonitor());
			monitor.worked(1);
			EclipseHelper.createFile("src/metamodel/Extensions.ext", p, getContents("Extensions.ext"), new NullProgressMonitor());
			monitor.worked(1);
			EclipseHelper.createFile("src/metamodel/metamodel.ecore", p, getContents("metamodel.ecore"), new NullProgressMonitor());
			monitor.worked(1);
			EclipseHelper.createFile("src/template/GeneratorExtensions.ext", p, getContents("GeneratorExtensions.ext"),
					new NullProgressMonitor());
			monitor.worked(1);
			EclipseHelper.createFile("src/template/Template.xpt", p, getContents("Template.xpt"), new NullProgressMonitor());
			monitor.worked(1);
			EclipseHelper.createFile("src/workflow/generator.mwe", p, getContents("generator.mwe").replace(
					"PROJECTNAME", projectName), new NullProgressMonitor());
			monitor.worked(1);
			EclipseHelper.createFile("src/workflow/generatorWithBackend.mwe", p, getContents("generatorWithBackend.mwe").replace(
					"PROJECTNAME", projectName), new NullProgressMonitor());
			monitor.worked(1);
			EclipseHelper.createFile("src/workflow/generatorWithProfiler.mwe", p, getContents("generatorWithProfiler.mwe").replace(
					"PROJECTNAME", projectName), new NullProgressMonitor());
			monitor.worked(1);
			EclipseHelper.createFile("src/Model.xmi", p, getContents("Model.xmi"), new NullProgressMonitor());
			monitor.worked(1);
			
		}
		
		else if (projectSpecific) {
			EclipseHelper.createFile(".settings/org.eclipse.xtend.shared.ui.prefs", p,
					"eclipse.preferences.version=1\n"+PreferenceConstants.PROJECT_SPECIFIC_METAMODEL+"=true\n"
					+PreferenceConstants.METAMODELCONTRIBUTORS+"=" + page.getStoreString(), new NullProgressMonitor());
			monitor.worked(1);
		}
		
		monitor.worked(1);
	}

	
	private String getContents(final String resource) {
		try {
			final InputStream inputStream = getClass().getClassLoader().getResourceAsStream(
					"org/eclipse/xtend/shared/ui/wizards/example/" + resource);

			final byte[] buffer = new byte[4096];
			final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

			while (true) {
				int read;
				read = inputStream.read(buffer);

				if (read == -1) {
					break;
				}

				outputStream.write(buffer, 0, read);
			}

			outputStream.close();
			inputStream.close();

			return outputStream.toString("iso-8859-1");
		}
		catch (final IOException e) {
			XtendLog.logError(e);
			return "";
		}
	}

	/**
	 * We will accept the selection in the workbench to see if we can initialize
	 * from it.
	 * 
	 * @see IWorkbenchWizard#init(IWorkbench, IStructuredSelection)
	 */
	public void init(final IWorkbench workbench, final IStructuredSelection selection) {
	}

	public void setInitializationData(final IConfigurationElement config, final String propertyName, final Object data)
			throws CoreException {
		this.configElement = config;
	}
}