/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.expr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.common.SourcePos;
import org.eclipse.xtend.backend.expr.LocalVarEvalExpression;
import org.eclipse.xtend.backend.syslib.CollectionOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvocationOnCollectionExpression
extends ExpressionBase {
    private final ExpressionBase _coll;
    private final QualifiedName _functionName;
    private final List<ExpressionBase> _params;

    public InvocationOnCollectionExpression(ExpressionBase coll, QualifiedName functionName, List<ExpressionBase> params, SourcePos sourcePos) {
        super(sourcePos);
        this._coll = coll;
        this._functionName = functionName;
        this._params = params;
    }

    public ExpressionBase getCollection() {
        return this._coll;
    }

    public QualifiedName getFunctionName() {
        return this._functionName;
    }

    public List<ExpressionBase> getParams() {
        return this._params;
    }

    @Override
    protected Object evaluateInternal(ExecutionContext ctx) {
        Collection coll = (Collection)this._coll.evaluate(ctx);
        boolean firstParamIsThis = false;
        if (this._params.size() > 0 && this._params.get(0) instanceof LocalVarEvalExpression && ((LocalVarEvalExpression)this._params.get(0)).getLocalVarName().equals("this")) {
            firstParamIsThis = true;
        }
        if (coll == null) {
            ctx.logNullDeRef(this.getPos());
            return null;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(null);
        for (ExpressionBase expr : this._params) {
            params.add(expr.evaluate(ctx));
        }
        Collection<Object> result = CollectionOperations.createMatchingCollection(coll);
        for (Object o : coll) {
            params.set(0, o);
            CollectionOperations.addFlattened(result, ctx.getFunctionDefContext().invoke(ctx, this._functionName, params, firstParamIsThis));
        }
        return result;
    }
}

