/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xpand;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.internal.xpand2.ast.Definition;
import org.eclipse.internal.xpand2.ast.ExpandStatement;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.parser.XpandParseFacade;
import org.eclipse.internal.xtend.xtend.parser.ParseException;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.Output;
import org.eclipse.xpand2.output.OutputImpl;
import org.eclipse.xpand2.output.PostProcessor;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowComponent;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.middleend.LanguageContributor;
import org.eclipse.xtend.middleend.xpand.XpandBackendFacade;
import org.eclipse.xtend.middleend.xpand.internal.xpandlib.pr.XpandProtectedRegionResolver;
import org.eclipse.xtend.middleend.xpand.plugin.OldXpandRegistryFactory;
import org.eclipse.xtend.middleend.xtend.plugin.OldXtendRegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandComponent
extends AbstractExpressionsUsingWorkflowComponent {
    private String _genPath = null;
    private String _srcPath = null;
    private String _expand = null;
    private String _fileEncoding = null;
    private boolean _automaticHyphens = false;
    private Output _output = null;
    private final List<Outlet> _outlets = new ArrayList<Outlet>();
    private List<PostProcessor> _postprocessors = new ArrayList<PostProcessor>();
    private List<Outlet> _initializedOutlets = new ArrayList<Outlet>();
    private String _ignoreList;
    private boolean _defaultExcludes;
    private boolean _useBase64;
    private boolean _logStackTrace;

    public XpandComponent() {
        if (LanguageContributor.INSTANCE.getLanguageContributionByName("Xtend") == null) {
            LanguageContributor.INSTANCE.addLanguageContribution(OldXtendRegistryFactory.class);
        }
        if (LanguageContributor.INSTANCE.getLanguageContributionByName("Xpand") == null) {
            LanguageContributor.INSTANCE.addLanguageContribution(OldXpandRegistryFactory.class);
        }
    }

    public List<PostProcessor> getBeautifier() {
        return this._postprocessors;
    }

    public void addBeautifier(PostProcessor beautifier) {
        this._postprocessors.add(beautifier);
    }

    public List<PostProcessor> getPostprocessors() {
        return this._postprocessors;
    }

    public void addPostprocessor(PostProcessor postprocessor) {
        this._postprocessors.add(postprocessor);
    }

    public void setAutomaticHyphens(boolean automaticHyphens) {
        this._automaticHyphens = automaticHyphens;
    }

    public String getLogMessage() {
        return "generating '" + this._expand + "' => directory '" + this._genPath + "'";
    }

    public void setFileEncoding(String fileEncoding) {
        this._fileEncoding = fileEncoding;
    }

    public String getFileEncoding() {
        return this._fileEncoding;
    }

    public void setExpand(String invoke) {
        this._expand = invoke;
    }

    @Deprecated
    public void setGenPath(String genPath) {
        this._genPath = this.fixPath(genPath);
    }

    @Deprecated
    public void setSrcPath(String srcPath) {
        this._srcPath = this.fixPath(srcPath);
    }

    public void setIgnoreList(String ignoreList) {
        this._ignoreList = ignoreList;
    }

    public void setDefaultExcludes(boolean defaultExcludes) {
        this._defaultExcludes = defaultExcludes;
    }

    public void setUseBase64(boolean useBase64) {
        this._useBase64 = useBase64;
    }

    public void setLogStackTrace(boolean logStackTrace) {
        this._logStackTrace = logStackTrace;
    }

    private String fixPath(String p) {
        if (p.endsWith("\\")) {
            return p.replace('\\', '/');
        }
        if (p.endsWith("/")) {
            return p;
        }
        return String.valueOf(p) + "/";
    }

    protected void invokeInternal2(WorkflowContext wfContext, ProgressMonitor monitor, Issues issues) {
        XpandExecutionContextImpl executionContext = new XpandExecutionContextImpl(this.getOutput(), null, this.getGlobalVars(wfContext), null, this.getNullEvaluationHandler());
        if (this._fileEncoding != null) {
            executionContext.getResourceManager().setFileEncoding(this._fileEncoding);
        }
        String code = "\u00abEXPAND " + this._expand + "\u00bb";
        String filename = new String(this._expand.substring(0, this._expand.lastIndexOf("::")));
        XpandBackendFacade bf = XpandBackendFacade.createForFile(filename, this._fileEncoding, this.metaModels, this._outlets);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        String[] stringArray = wfContext.getSlotNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            variables.put(name, wfContext.get(name));
            ++n2;
        }
        XpandProtectedRegionResolver resolver = new XpandProtectedRegionResolver(this._ignoreList, this._defaultExcludes, this.getInitializedOutlets(), this._fileEncoding, this._useBase64);
        bf.executeStatement(code, variables, this.getGlobalVarsFromContext(this.getGlobalVars(wfContext)), this._advice, resolver, this._logStackTrace);
    }

    public void addOutlet(Outlet outlet) {
        this._outlets.add(outlet);
    }

    public void setOutput(Output output) {
        this._output = output;
    }

    private Output getOutput() {
        if (this._output == null) {
            OutputImpl out = new OutputImpl();
            out.setAutomaticHyphens(this._automaticHyphens);
            this._output = out;
        }
        return this._output;
    }

    private List<Outlet> getInitializedOutlets() {
        if (this._initializedOutlets.isEmpty()) {
            ArrayList<Outlet> result = new ArrayList<Outlet>(this._outlets);
            if (result.isEmpty()) {
                if (this._genPath != null) {
                    result.add(new Outlet(false, this._fileEncoding, null, true, this._genPath));
                    result.add(new Outlet(true, this._fileEncoding, "APPEND", true, this._genPath));
                }
                if (this._srcPath != null) {
                    result.add(new Outlet(false, this._fileEncoding, "ONCE", false, this._srcPath));
                }
            }
            for (Outlet o : result) {
                if (o.postprocessors.isEmpty()) {
                    for (PostProcessor pp : this._postprocessors) {
                        o.addPostprocessor(pp);
                    }
                }
                if (this._fileEncoding == null) continue;
                o.setFileEncoding(this._fileEncoding);
            }
            this._initializedOutlets = result;
        }
        return this._initializedOutlets;
    }

    private ExpandStatement getStatement() {
        Template tpl = XpandParseFacade.file((Reader)new StringReader("\u00abDEFINE test FOR test\u00bb\u00abEXPAND " + this._expand + "\u00bb" + "\u00ab" + "ENDDEFINE" + "\u00bb"), null);
        ExpandStatement es = null;
        try {
            es = (ExpandStatement)((Definition)tpl.getDefinitions()[0]).getBody()[1];
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return es;
    }

    public void checkConfigurationInternal(Issues issues) {
        super.checkConfigurationInternal(issues);
        if (this._genPath == null && this.getInitializedOutlets().isEmpty()) {
            issues.addError((WorkflowComponent)this, "You need to configure at least one outlet!");
        }
        if (!(this._genPath == null && this._srcPath == null || this._outlets.isEmpty())) {
            issues.addWarning((WorkflowComponent)this, "'genPath' is ignored since you have specified outlets!");
        }
        int defaultOutlets = 0;
        for (Outlet o : this.getInitializedOutlets()) {
            if (o.getName() != null) continue;
            ++defaultOutlets;
        }
        if (defaultOutlets > 1) {
            issues.addError((WorkflowComponent)this, "Only one outlet can be the default outlet. Please specifiy a name for the other outlets!");
        } else if (defaultOutlets == 0) {
            issues.addWarning((WorkflowComponent)this, "No default outlet configured!");
        }
        if (this._expand == null) {
            issues.addError((WorkflowComponent)this, "property 'expand' not configured!");
        } else {
            try {
                ExpandStatement es = this.getStatement();
                if (es == null) {
                    issues.addError((WorkflowComponent)this, "property 'expand' has wrong syntax!");
                }
            }
            catch (ParseException e) {
                issues.addError((WorkflowComponent)this, "property 'expand' has wrong syntax : " + e.getMessage());
            }
        }
    }

    public Map<String, Object> getGlobalVarsFromContext(Map<String, Variable> globalVars) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        if (globalVars != null) {
            for (String varName : globalVars.keySet()) {
                vars.put(varName, globalVars.get(varName).getValue());
            }
        }
        return vars;
    }
}

