/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.ResourceContributor;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandMarkerManager;
import org.eclipse.xtend.shared.ui.core.internal.BuildState;
import org.eclipse.xtend.shared.ui.core.internal.JDTUtil;
import org.eclipse.xtend.shared.ui.core.internal.ResourceID;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendXpandBuilder
extends IncrementalProjectBuilder {
    private final Set<String> extensions = new HashSet<String>();
    private int incrementalAnalyzerStrategy;
    private Set<IXtendXpandResource> toAnalyze = null;

    public XtendXpandBuilder() {
        ResourceContributor[] contributors;
        ResourceContributor[] resourceContributorArray = contributors = Activator.getRegisteredResourceContributors();
        int n = contributors.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceContributor resourceContributor = resourceContributorArray[n2];
            this.extensions.add(resourceContributor.getFileExtension());
            ++n2;
        }
    }

    private void updateIncrementalAnalyzerStrategy() {
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), Activator.getId());
        this.incrementalAnalyzerStrategy = scopedPreferenceStore.getInt("incrementalAnalyzerStrategy");
    }

    private boolean analyzeReverseReferencedResources() {
        return this.incrementalAnalyzerStrategy == 3;
    }

    private boolean analyzeWholeProjectWhenIncremental() {
        switch (this.incrementalAnalyzerStrategy) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static final String getBUILDER_ID() {
        return String.valueOf(Activator.getId()) + ".xtendBuilder";
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        SubMonitor buildMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor subMon = null;
        this.toAnalyze = new HashSet<IXtendXpandResource>();
        try {
            subMon = buildMonitor.newChild(40);
            IResourceDelta delta = this.getDelta(this.getProject());
            if (kind == 6 || kind == 15 || delta == null) {
                this.fullBuild((IProgressMonitor)subMon);
            } else {
                this.incrementalBuild(delta, (IProgressMonitor)subMon);
            }
        }
        catch (Throwable e) {
            XtendLog.logError(e);
        }
        subMon = buildMonitor.newChild(55);
        this.analyzeResources(kind, buildMonitor);
        buildMonitor.subTask("Updating resource markers");
        XtendXpandMarkerManager.finishBuild();
        buildMonitor.worked(5);
        this.toAnalyze = null;
        return null;
    }

    private void analyzeResources(int kind, SubMonitor monitor) {
        int work = this.toAnalyze.size() + 1;
        monitor.setWorkRemaining(work);
        monitor.subTask("Collecting resources for analysis");
        HashMap<IXtendXpandProject, ArrayList<IXtendXpandResource>> groupByProject = new HashMap<IXtendXpandProject, ArrayList<IXtendXpandResource>>();
        for (IXtendXpandResource resource : this.toAnalyze) {
            IXtendXpandProject xtdxptProject = (IXtendXpandProject)resource.getAdapter(IXtendXpandProject.class);
            ArrayList<IXtendXpandResource> resources = (ArrayList<IXtendXpandResource>)groupByProject.get(xtdxptProject);
            if (resources == null) {
                resources = new ArrayList<IXtendXpandResource>();
                groupByProject.put(xtdxptProject, resources);
            }
            resources.add(resource);
        }
        monitor.worked(1);
        int i = 1;
        for (IXtendXpandProject project : groupByProject.keySet()) {
            ExecutionContext execCtx = Activator.getExecutionContext(project.getProject());
            BuildState.set(execCtx);
            try {
                for (IXtendXpandResource resource : (List)groupByProject.get(project)) {
                    String resName = resource.getUnderlyingStorage() != null ? resource.getUnderlyingStorage().getFullPath().toString() : resource.getFullyQualifiedName();
                    StringBuilder msg = new StringBuilder("Analyzing resource ").append(i++).append('/').append(work - 1).append(' ').append(resName);
                    monitor.subTask(msg.toString());
                    resource.analyze(execCtx);
                    monitor.worked(1);
                }
            }
            finally {
                BuildState.remove(execCtx);
            }
        }
    }

    private void fillToAnalyzeWithReverseReferencedResources() {
        HashSet<IXtendXpandResource> reverseReferences = new HashSet<IXtendXpandResource>();
        for (IXtendXpandResource name : this.toAnalyze) {
            IXtendXpandResource[] resources;
            IXtendXpandResource res = name;
            IResource resource = (IResource)res.getUnderlyingStorage();
            IProject project = resource.getProject();
            if (project.isLinked()) continue;
            IXtendXpandProject xtdxptProject = Activator.getExtXptModelManager().findProject((IResource)project);
            IXtendXpandResource[] iXtendXpandResourceArray = resources = xtdxptProject.getAllRegisteredResources();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IXtendXpandResource iXtendXpandResource = iXtendXpandResourceArray[n2];
                if (iXtendXpandResource != null) {
                    String[] stringArray = iXtendXpandResource.getImportedExtensions();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string = stringArray[n4];
                        IXtendXpandResource importedResource = xtdxptProject.findExtXptResource(string, "ext");
                        if (importedResource != null && importedResource.equals(res)) {
                            reverseReferences.add(iXtendXpandResource);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        this.toAnalyze.addAll(reverseReferences);
    }

    void reloadResource(IFile resource) {
        IXtendXpandResource r;
        IXtendXpandProject project;
        if (resource.exists() && (project = Activator.getExtXptModelManager().findProject((IResource)resource)) != null && (r = project.findXtendXpandResource((IStorage)resource)) != null) {
            if (r.refresh()) {
                resource.getLocalTimeStamp();
            }
            if (!this.isInExternalPackageFragmentRoot(r)) {
                this.toAnalyze.add(r);
            }
        }
    }

    private boolean isInExternalPackageFragmentRoot(IXtendXpandResource resource) {
        IStorage underlyingStorage = resource.getUnderlyingStorage();
        IProject containerProject = null;
        if (underlyingStorage instanceof IJarEntryResource) {
            containerProject = ((IJarEntryResource)underlyingStorage).getPackageFragmentRoot().getJavaProject().getProject();
        }
        if (underlyingStorage instanceof IFile) {
            containerProject = ((IFile)underlyingStorage).getProject();
        }
        return containerProject != null && containerProject.isHidden();
    }

    public void handleRemovement(IFile resource) {
        IXtendXpandProject project = Activator.getExtXptModelManager().findProject((IResource)resource);
        if (project != null) {
            project.unregisterXtendXpandResource(project.findXtendXpandResource((IStorage)resource));
        } else {
            XtendLog.logInfo("No Xpand project found for " + resource.getProject().getName());
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        IProject iProject = this.getProject();
        IXtendXpandProject project = (IXtendXpandProject)iProject.getAdapter(IXtendXpandProject.class);
        if (project != null) {
            XtendXpandDeltaVisitor visitor = new XtendXpandDeltaVisitor(monitor);
            iProject.accept((IResourceVisitor)visitor);
            this.processResources(monitor, visitor.toLoad, visitor.toUnload);
            this.scanArchives(monitor, project);
            monitor.worked(1);
        } else {
            XtendLog.logInfo("Couldn't create Xpand project for project " + iProject.getName());
        }
    }

    void processResources(IProgressMonitor monitor, List<IResource> toLoad, List<IResource> toUnload) {
        StringBuilder msg;
        int work = toLoad.size() + toUnload.size();
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)work);
        int i = 0;
        for (IResource r : toLoad) {
            msg = new StringBuilder("Loading resource ").append(i++).append('/').append(toLoad.size()).append(' ').append(r.getFullPath());
            subMon.subTask(msg.toString());
            this.reloadResource((IFile)r);
            subMon.worked(1);
        }
        i = 0;
        for (IResource r : toUnload) {
            msg = new StringBuilder("Unloading resource ").append(i++).append('/').append(toUnload.size()).append(' ').append(r.getFullPath());
            subMon.subTask(msg.toString());
            this.handleRemovement((IFile)r);
            subMon.worked(1);
        }
    }

    private void scanArchives(IProgressMonitor monitor, IXtendXpandProject project) throws JavaModelException {
        IJavaProject jp = project.getProject();
        IPackageFragmentRoot[] roots = jp.getPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> archives = new ArrayList<IPackageFragmentRoot>(roots.length);
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.isArchive()) {
                archives.add(root);
            }
            ++n2;
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask("Scanning archives ", archives.size());
        for (IPackageFragmentRoot root : archives) {
            try {
                String archiveName = root.getCorrespondingResource() != null ? root.getCorrespondingResource().getFullPath().toString() : root.getElementName();
                ZipFile zip = ((JarPackageFragmentRoot)root).getJar();
                if (Activator.getDefault().isBlacklistedJar(new File(zip.getName()).getName())) continue;
                subMonitor.subTask("Scanning archive " + archiveName);
                boolean addToBlacklist = true;
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    String ext;
                    ZipEntry entry = entries.nextElement();
                    if (entry.getSize() == 0L) continue;
                    String name = entry.getName();
                    int fileExtOffset = name.lastIndexOf(46);
                    String string = ext = fileExtOffset > 0 ? name.substring(fileExtOffset + 1) : null;
                    if (!this.extensions.contains(ext)) continue;
                    String fqn = name.substring(0, fileExtOffset).replace("/", "::");
                    ResourceID resourceID = new ResourceID(fqn, ext);
                    IStorage findStorage = JDTUtil.loadFromJar(resourceID, root);
                    subMonitor.subTask("Scanning archive " + archiveName + " - Loading resource " + findStorage.getFullPath());
                    project.findXtendXpandResource(findStorage);
                    addToBlacklist = false;
                    break;
                }
                if (!addToBlacklist) continue;
                Activator.getDefault().addToJarBlacklist(new File(zip.getName()).getName());
            }
            catch (CoreException ex) {
                XtendLog.logError(ex);
            }
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        this.updateIncrementalAnalyzerStrategy();
        XtendXpandDeltaVisitor visitor = new XtendXpandDeltaVisitor(monitor);
        delta.accept((IResourceDeltaVisitor)visitor);
        if (this.analyzeReverseReferencedResources()) {
            this.fillToAnalyzeWithReverseReferencedResources();
        }
        if (this.analyzeWholeProjectWhenIncremental()) {
            final XtendXpandDeltaVisitor visitor2 = new XtendXpandDeltaVisitor((IProgressMonitor)new NullProgressMonitor());
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getResource().getType() == 4) {
                        visitor2.visit(delta.getResource());
                    }
                    return false;
                }
            });
            for (IResource res : visitor2.toLoad) {
                IXtendXpandResource xpr = (IXtendXpandResource)res.getAdapter(IXtendXpandResource.class);
                if (xpr == null) continue;
                this.toAnalyze.add(xpr);
            }
        }
        this.processResources(monitor, visitor.toLoad, visitor.toUnload);
    }

    class XtendXpandDeltaVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        private final IProgressMonitor monitor;
        private IFolder outputFolder;
        private final List<IResource> toLoad = new LinkedList<IResource>();
        private final List<IResource> toUnload = new LinkedList<IResource>();

        public XtendXpandDeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
            IProject project = XtendXpandBuilder.this.getProject();
            try {
                IJavaProject javaProject;
                IPath outputLocation;
                if (project.hasNature("org.eclipse.jdt.core.javanature") && (outputLocation = (javaProject = JavaCore.create((IProject)project)).getOutputLocation()) != null) {
                    this.outputFolder = project.getWorkspace().getRoot().getFolder(outputLocation);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (this.isXtendXpandResource(resource)) {
                switch (delta.getKind()) {
                    case 1: {
                        this.toLoad.add(resource);
                        break;
                    }
                    case 2: {
                        this.toUnload.add(resource);
                        break;
                    }
                    case 4: {
                        this.toLoad.add(resource);
                    }
                }
                this.monitor.worked(1);
            }
            return !resource.equals((Object)this.outputFolder);
        }

        private boolean isXtendXpandResource(IResource resource) {
            return resource.getType() == 1 && XtendXpandBuilder.this.extensions.contains(resource.getFileExtension());
        }

        public boolean visit(IResource resource) {
            if (this.isXtendXpandResource(resource)) {
                this.toLoad.add(resource);
            }
            return !resource.equals((Object)this.outputFolder);
        }
    }
}

