/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.expr;

import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.SourcePos;
import org.eclipse.xtend.backend.common.StacktraceEntry;

public final class NewLocalVarDefExpression
extends ExpressionBase {
    private final String _localVarName;
    private final ExpressionBase _defExpression;
    private final ExpressionBase _inner;

    public NewLocalVarDefExpression(String localVarName, ExpressionBase defExpression, ExpressionBase inner, SourcePos sourcePos) {
        super(sourcePos);
        this._localVarName = localVarName;
        this._defExpression = defExpression;
        this._inner = inner;
    }

    public String getLocalVarName() {
        return this._localVarName;
    }

    public ExpressionBase getDefExpression() {
        return this._defExpression;
    }

    public ExpressionBase getInnerExpression() {
        return this._inner;
    }

    protected Object evaluateInternal(ExecutionContext ctx) {
        ctx.getLocalVarContext().getLocalVars().put(this._localVarName, this._defExpression.evaluate(ctx));
        if (ctx.isLogStacktrace()) {
            ctx.getStacktrace().add(new StacktraceEntry(this.getPos(), ctx));
        }
        try {
            Object object = this._inner.evaluate(ctx);
            return object;
        }
        finally {
            if (ctx.isLogStacktrace()) {
                ctx.getStacktrace().remove(ctx.getStacktrace().size() - 1);
            }
            ctx.getLocalVarContext().getLocalVars().remove(this._localVarName);
        }
    }
}

