/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.util.logging.Logger;
import prefuse.action.EncoderAction;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.util.ColorLib;
import prefuse.util.PrefuseLib;
import prefuse.visual.VisualItem;

public class ColorAction
extends EncoderAction {
    protected String m_colorField;
    protected String m_startField;
    protected String m_endField;
    protected int m_cidx;
    protected int m_sidx;
    protected int m_eidx;
    protected int m_defaultColor = ColorLib.gray(0);

    public ColorAction(String group, String field) {
        super(group);
        this.setField(field);
    }

    public ColorAction(String group, String field, int color) {
        this(group, field);
        this.m_defaultColor = color;
    }

    public ColorAction(String group, Predicate filter, String field) {
        super(group, filter);
        this.setField(field);
    }

    public ColorAction(String group, Predicate filter, String field, int color) {
        this(group, filter, field);
        this.setDefaultColor(color);
    }

    public void setField(String field) {
        this.m_colorField = field;
        this.m_startField = PrefuseLib.getStartField(field);
        this.m_endField = PrefuseLib.getEndField(field);
    }

    public int getDefaultColor() {
        return this.m_defaultColor;
    }

    public void setDefaultColor(int color) {
        this.m_defaultColor = color;
    }

    public void add(Predicate p, int color) {
        super.add(p, new Integer(color));
    }

    public void add(String expr, int color) {
        Predicate p = (Predicate)ExpressionParser.parse(expr);
        this.add(p, color);
    }

    public void add(Predicate p, ColorAction f) {
        super.add(p, f);
    }

    public void add(String expr, ColorAction f) {
        Predicate p = (Predicate)ExpressionParser.parse(expr);
        super.add(p, f);
    }

    public void process(VisualItem item, double frac) {
        int c = this.getColor(item);
        int o = item.getInt(this.m_colorField);
        item.setInt(this.m_startField, o);
        item.setInt(this.m_endField, c);
        item.setInt(this.m_colorField, c);
    }

    public int getColor(VisualItem item) {
        Object o = this.lookup(item);
        if (o != null) {
            if (o instanceof ColorAction) {
                return ((ColorAction)o).getColor(item);
            }
            if (o instanceof Integer) {
                return (Integer)o;
            }
            Logger.getLogger(this.getClass().getName()).warning("Unrecognized Object from predicate chain.");
        }
        return this.m_defaultColor;
    }
}

