/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import java.util.concurrent.CopyOnWriteArrayList;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;
import prefuse.data.expression.Function;

public abstract class FunctionExpression
extends AbstractExpression
implements Function {
    protected CopyOnWriteArrayList m_params;
    protected final int m_pcount;

    protected FunctionExpression(int parameterCount) {
        this.m_pcount = parameterCount;
    }

    public abstract String getName();

    public void addParameter(Expression e) {
        int pc = this.getParameterCount();
        if (pc != -1 && this.paramCount() + 1 > pc) {
            throw new IllegalStateException("This function takes only " + pc + " parameters.");
        }
        if (this.m_params == null) {
            this.m_params = new CopyOnWriteArrayList();
        }
        this.m_params.add(e);
    }

    protected int paramCount() {
        return this.m_params == null ? 0 : this.m_params.size();
    }

    protected final Expression param(int idx) {
        return (Expression)this.m_params.get(idx);
    }

    public int getParameterCount() {
        return this.m_pcount;
    }

    protected void missingParams() {
        throw new IllegalStateException("Function is missing parameters: " + this.getName());
    }

    public void visit(ExpressionVisitor v) {
        v.visitExpression(this);
        if (this.paramCount() > 0) {
            Object[] params = this.m_params.toArray();
            int i = 0;
            while (i < params.length) {
                v.down();
                ((Expression)params[i]).visit(v);
                v.up();
                ++i;
            }
        }
    }

    protected void addChildListeners() {
        if (this.paramCount() > 0) {
            Object[] params = this.m_params.toArray();
            int i = 0;
            while (i < params.length) {
                ((Expression)params[i]).addExpressionListener(this);
                ++i;
            }
        }
    }

    protected void removeChildListeners() {
        if (this.paramCount() > 0) {
            Object[] params = this.m_params.toArray();
            int i = 0;
            while (i < params.length) {
                ((Expression)params[i]).removeExpressionListener(this);
                ++i;
            }
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.getName()).append('(');
        int i = 0;
        while (i < this.paramCount()) {
            if (i > 0) {
                sbuf.append(", ");
            }
            sbuf.append(this.param(i).toString());
            ++i;
        }
        sbuf.append(')');
        return sbuf.toString();
    }
}

