/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.ui.util;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IDiscovererList;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IDiscovererListFactory;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.BenchmarkFactory;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Discovery;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.launch.LaunchConfiguration;
import org.eclipse.modisco.infra.discovery.launch.LaunchFactory;
import org.eclipse.modisco.infra.discovery.launch.ParameterValue;
import org.eclipse.modisco.infra.discovery.ui.internal.dialogs.GenericParametersDialog;
import org.eclipse.modisco.infra.discovery.ui.internal.util.LaunchConfigurationUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscovererListComposite
extends AbstractCellEditorComposite<IDiscovererList> {
    private final Button button;
    private Text text = null;
    private IDiscovererList discoverers = null;
    private final Composite parentControl;

    public DiscovererListComposite(Composite parent) {
        this(parent, 0);
    }

    public DiscovererListComposite(Composite parent, int style) {
        super(parent);
        this.parentControl = parent;
        GridLayout gd = new GridLayout(2, false);
        gd.marginHeight = 0;
        gd.marginWidth = 0;
        gd.horizontalSpacing = 0;
        this.setLayout((Layout)gd);
        this.text = new Text((Composite)this, style);
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.button = new Button((Composite)this, 8);
        this.button.setText("...");
        GridData data = new GridData(4, 4, false, true);
        this.button.setLayoutData((Object)data);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscovererListComposite.this.browseResource();
            }
        });
        final Listener clickListener = new Listener(){

            public void handleEvent(Event event) {
                Control control;
                if (event.widget instanceof Control && (control = (Control)event.widget).getShell() == DiscovererListComposite.this.getParentControl().getShell() && event.widget != DiscovererListComposite.this.getButton() && event.widget != DiscovererListComposite.this.getText()) {
                    DiscovererListComposite.this.fireCommit();
                }
            }
        };
        Display.getDefault().addFilter(3, clickListener);
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Display.getDefault().removeFilter(3, clickListener);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    DiscovererListComposite.this.fireCommit();
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    DiscovererListComposite.this.close();
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DiscovererListComposite.this.fireChanged();
            }
        });
        this.text.forceFocus();
    }

    protected Button getButton() {
        return this.button;
    }

    protected Text getText() {
        return this.text;
    }

    protected void commit() {
        this.fireCommit();
    }

    protected Composite getParentControl() {
        return this.parentControl;
    }

    public IDiscovererList getValue() {
        return this.discoverers;
    }

    protected void browseResource() {
        Object[] result;
        WorkbenchContentProvider discovererContentProvider = new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (IDiscoveryManager.INSTANCE.getDiscoverers().size() == 0) {
                    return new Object[0];
                }
                LinkedList<String> discovererIds = new LinkedList<String>();
                for (DiscovererDescription discoDesc : IDiscoveryManager.INSTANCE.getDiscoverers()) {
                    discovererIds.add(discoDesc.getId());
                }
                return discovererIds.toArray();
            }
        };
        LabelProvider discovererLabelProvider = new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        };
        ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), (Object)IDiscoveryManager.INSTANCE.getDiscoverers(), (IStructuredContentProvider)discovererContentProvider, (ILabelProvider)discovererLabelProvider, "Please select one or more discoverers");
        dialog.setTitle("Select Discoverers");
        int code = dialog.open();
        if (code == 0 && (result = dialog.getResult()).length > 0) {
            IDiscovererList selectedDiscoverers = IDiscovererListFactory.INSTANCE.createDiscovererList();
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object name = objectArray[n2];
                AbstractModelDiscoverer discoverer = (AbstractModelDiscoverer)IDiscoveryManager.INSTANCE.createDiscovererImpl((String)name);
                Discovery disco = BenchmarkFactory.eINSTANCE.createDiscovery();
                disco.setDiscovererId((String)name);
                DiscovererDescription discovererDescription = IDiscoveryManager.INSTANCE.getDiscovererDescription((String)name);
                if (discovererDescription != null) {
                    disco.setDiscovererClassName(discovererDescription.getImplementationType().getCanonicalName());
                    disco.setCopyOfDiscovererDescription(discovererDescription);
                }
                LaunchConfigurationUtils lcu = new LaunchConfigurationUtils(discovererDescription, null, this.getShell());
                List inParameters = LaunchConfigurationUtils.getExpectedInputParameters((DiscovererDescription)discovererDescription);
                if (!inParameters.isEmpty()) {
                    LaunchConfiguration configuration = LaunchFactory.eINSTANCE.createLaunchConfiguration();
                    configuration.setOpenModelAfterDiscovery(false);
                    boolean showOpenModelCheckbox = discoverer instanceof AbstractModelDiscoverer;
                    GenericParametersDialog genericParametersDialog = new GenericParametersDialog(this.getShell(), inParameters, discovererDescription.getId(), showOpenModelCheckbox, configuration);
                    int res = genericParametersDialog.open();
                    if (res == 0) {
                        Object[] parameterValues = genericParametersDialog.getParameterValues();
                        assert (parameterValues.length == inParameters.size());
                        int i = 0;
                        while (i < inParameters.size()) {
                            DiscovererParameter parameter = (DiscovererParameter)inParameters.get(i);
                            ParameterValue pvalue = LaunchFactory.eINSTANCE.createParameterValue();
                            pvalue.setParameter(parameter);
                            pvalue.setValue(parameterValues[i]);
                            configuration.getParameterValues().add((Object)pvalue);
                            ++i;
                        }
                    }
                    disco.setDiscovererLaunchConfiguration(configuration);
                }
                selectedDiscoverers.add(disco);
                ++n2;
            }
            this.setValue(selectedDiscoverers);
            this.fireCommit();
        }
    }

    public void setValue(IDiscovererList value) {
        if (value != null) {
            this.discoverers = value;
            if (this.discoverers.size() == 1) {
                this.text.setText(this.discoverers.get(0).getDiscovererId());
            } else if (this.discoverers.size() > 1) {
                this.text.setText("\"" + this.discoverers.get(0).getDiscovererId() + "\" and " + (this.discoverers.size() - 1) + " more ...");
            } else {
                this.text.setText("");
            }
        }
    }
}

