/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.Activator;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IProjectSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSet
implements IProjectSet {
    private List<IProject> projects = new LinkedList<IProject>();
    private Map<IProject, Long> projectSize = new HashMap<IProject, Long>();

    public long getProjectSize(IProject p) throws CoreException {
        if (this.projectSize.keySet().contains(p)) {
            return this.projectSize.get(p);
        }
        if (this.projects.contains(p)) {
            long s = this.size((IContainer)p);
            this.projectSize.put(p, s);
            return s;
        }
        return this.size((IContainer)p);
    }

    @Override
    public void add(int arg0, IProject arg1) {
        this.projects.add(arg0, arg1);
    }

    @Override
    public boolean add(IProject toAdd) {
        return this.projects.add(toAdd);
    }

    @Override
    public IProjectSet sortBySize() {
        Collections.sort(this.projects, new Comparator<IProject>(){

            @Override
            public int compare(IProject arg0, IProject arg1) {
                block6: {
                    block5: {
                        try {
                            if (ProjectSet.this.getProjectSize(arg0) >= ProjectSet.this.getProjectSize(arg1)) break block5;
                            return -1;
                        }
                        catch (CoreException e) {
                            MoDiscoLogger.logError((Throwable)e, (String)"Could not compute size of a project. The project set will not be sorted.", (Plugin)Activator.getDefault());
                            return 0;
                        }
                    }
                    if (ProjectSet.this.getProjectSize(arg0) != ProjectSet.this.getProjectSize(arg1)) break block6;
                    return 0;
                }
                if (ProjectSet.this.getProjectSize(arg0) > ProjectSet.this.getProjectSize(arg1)) {
                    return 1;
                }
                return 0;
            }
        });
        return this;
    }

    private long size(IContainer container) throws CoreException {
        long size = 0L;
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFolder) {
                size += this.size((IContainer)res);
            } else if (res instanceof IFile) {
                IFileStore fileStore = EFS.getStore((URI)res.getLocationURI());
                size += fileStore.fetchInfo().getLength();
            }
            ++n2;
        }
        return size;
    }

    @Override
    public boolean addAll(Collection<? extends IProject> arg0) {
        return this.projects.addAll(arg0);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends IProject> arg1) {
        return this.projects.addAll(arg0, arg1);
    }

    @Override
    public void clear() {
        this.projects.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.projects.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.projects.containsAll(arg0);
    }

    @Override
    public boolean equals(Object arg0) {
        return this.projects.equals(arg0);
    }

    @Override
    public IProject get(int arg0) {
        return this.projects.get(arg0);
    }

    @Override
    public int hashCode() {
        return this.projects.hashCode();
    }

    @Override
    public int indexOf(Object arg0) {
        return this.projects.indexOf(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.projects.isEmpty();
    }

    @Override
    public Iterator<IProject> iterator() {
        return this.projects.iterator();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.projects.lastIndexOf(arg0);
    }

    @Override
    public ListIterator<IProject> listIterator() {
        return this.projects.listIterator();
    }

    @Override
    public ListIterator<IProject> listIterator(int arg0) {
        return this.projects.listIterator(arg0);
    }

    @Override
    public IProject remove(int arg0) {
        return this.projects.remove(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.projects.remove(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.projects.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.projects.retainAll(arg0);
    }

    @Override
    public IProject set(int arg0, IProject arg1) {
        return this.projects.set(arg0, arg1);
    }

    @Override
    public int size() {
        return this.projects.size();
    }

    @Override
    public List<IProject> subList(int arg0, int arg1) {
        return this.projects.subList(arg0, arg1);
    }

    @Override
    public Object[] toArray() {
        return this.projects.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.projects.toArray(arg0);
    }

    @Override
    public List<IProject> getProjects() {
        return this.projects;
    }
}

