/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.BitSet;
import java.util.Set;
import prefuse.data.DataTypeException;
import prefuse.data.Table;
import prefuse.data.column.AbstractColumn;
import prefuse.data.column.Column;
import prefuse.data.column.ColumnFactory;
import prefuse.data.event.ColumnListener;
import prefuse.data.event.ExpressionListener;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionAnalyzer;

public class ExpressionColumn
extends AbstractColumn {
    private Expression m_expr;
    private Table m_table;
    private Set m_columns;
    private BitSet m_valid;
    private Column m_cache;
    private Listener m_lstnr;

    public ExpressionColumn(Table table, Expression expr) {
        super(expr.getType(table.getSchema()));
        this.m_table = table;
        this.m_expr = expr;
        this.m_lstnr = new Listener();
        this.init();
        int nrows = this.m_table.getRowCount();
        this.m_cache = ColumnFactory.getColumn(this.getColumnType(), nrows);
        this.m_valid = new BitSet(nrows);
        this.m_expr.addExpressionListener(this.m_lstnr);
    }

    protected void init() {
        Column col;
        if (this.m_columns != null && this.m_columns.size() > 0) {
            for (String field : this.m_columns) {
                col = this.m_table.getColumn(field);
                col.removeColumnListener(this.m_lstnr);
            }
        }
        this.m_columns = ExpressionAnalyzer.getReferencedColumns(this.m_expr);
        for (String name : this.m_columns) {
            if (this.m_table.getColumn(name) != null) continue;
            throw new IllegalArgumentException("Table must contain all columns referenced by the expression. Bad column name: " + name);
        }
        for (String field : this.m_columns) {
            col = this.m_table.getColumn(field);
            col.addColumnListener(this.m_lstnr);
        }
    }

    public int getRowCount() {
        return this.m_cache.getRowCount();
    }

    public void setMaximumRow(int nrows) {
        this.m_cache.setMaximumRow(nrows);
    }

    public boolean isCacheValid(int row) {
        return this.m_valid.get(row);
    }

    public void invalidateCache(int start, int end) {
        this.m_valid.clear(start, end + 1);
    }

    public void revertToDefault(int row) {
    }

    public boolean canSet(Class type) {
        return false;
    }

    public Object get(int row) {
        Class type;
        this.rangeCheck(row);
        if (this.isCacheValid(row)) {
            return this.m_cache.get(row);
        }
        Object val = this.m_expr.get(this.m_table.getTuple(row));
        Class clazz = type = val == null ? Object.class : val.getClass();
        if (this.m_cache.canSet(type)) {
            this.m_cache.set(val, row);
            this.m_valid.set(row);
        }
        return val;
    }

    public void set(Object val, int row) throws DataTypeException {
        throw new UnsupportedOperationException();
    }

    private void rangeCheck(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    public boolean getBoolean(int row) throws DataTypeException {
        if (!this.canGetBoolean()) {
            throw new DataTypeException(Boolean.TYPE);
        }
        this.rangeCheck(row);
        if (this.isCacheValid(row)) {
            return this.m_cache.getBoolean(row);
        }
        boolean value = this.m_expr.getBoolean(this.m_table.getTuple(row));
        this.m_cache.setBoolean(value, row);
        this.m_valid.set(row);
        return value;
    }

    private void computeNumber(int row) {
        if (this.m_columnType == Integer.TYPE || this.m_columnType == Byte.TYPE) {
            this.m_cache.setInt(this.m_expr.getInt(this.m_table.getTuple(row)), row);
        } else if (this.m_columnType == Long.TYPE) {
            this.m_cache.setLong(this.m_expr.getLong(this.m_table.getTuple(row)), row);
        } else if (this.m_columnType == Float.TYPE) {
            this.m_cache.setFloat(this.m_expr.getFloat(this.m_table.getTuple(row)), row);
        } else {
            this.m_cache.setDouble(this.m_expr.getDouble(this.m_table.getTuple(row)), row);
        }
        this.m_valid.set(row);
    }

    public int getInt(int row) throws DataTypeException {
        if (!this.canGetInt()) {
            throw new DataTypeException(Integer.TYPE);
        }
        this.rangeCheck(row);
        if (!this.isCacheValid(row)) {
            this.computeNumber(row);
        }
        return this.m_cache.getInt(row);
    }

    public double getDouble(int row) throws DataTypeException {
        if (!this.canGetDouble()) {
            throw new DataTypeException(Double.TYPE);
        }
        this.rangeCheck(row);
        if (!this.isCacheValid(row)) {
            this.computeNumber(row);
        }
        return this.m_cache.getDouble(row);
    }

    public float getFloat(int row) throws DataTypeException {
        if (!this.canGetFloat()) {
            throw new DataTypeException(Float.TYPE);
        }
        this.rangeCheck(row);
        if (!this.isCacheValid(row)) {
            this.computeNumber(row);
        }
        return this.m_cache.getFloat(row);
    }

    public long getLong(int row) throws DataTypeException {
        if (!this.canGetLong()) {
            throw new DataTypeException(Long.TYPE);
        }
        this.rangeCheck(row);
        if (!this.isCacheValid(row)) {
            this.computeNumber(row);
        }
        return this.m_cache.getLong(row);
    }

    private class Listener
    implements ColumnListener,
    ExpressionListener {
        private Listener() {
        }

        public void columnChanged(int start, int end) {
            if (start == end && ExpressionColumn.this.isCacheValid(start)) {
                if (!ExpressionColumn.this.m_table.isValidRow(start)) {
                    return;
                }
                ExpressionColumn.this.invalidateCache(start, end);
                Class type = ExpressionColumn.this.getColumnType();
                if (Integer.TYPE == type) {
                    ExpressionColumn.this.fireColumnEvent(start, ExpressionColumn.this.m_cache.getInt(start));
                } else if (Long.TYPE == type) {
                    ExpressionColumn.this.fireColumnEvent(start, ExpressionColumn.this.m_cache.getLong(start));
                } else if (Float.TYPE == type) {
                    ExpressionColumn.this.fireColumnEvent(start, ExpressionColumn.this.m_cache.getFloat(start));
                } else if (Double.TYPE == type) {
                    ExpressionColumn.this.fireColumnEvent(start, ExpressionColumn.this.m_cache.getDouble(start));
                } else if (Boolean.TYPE == type) {
                    ExpressionColumn.this.fireColumnEvent(start, ExpressionColumn.this.m_cache.getBoolean(start));
                } else {
                    ExpressionColumn.this.fireColumnEvent(start, ExpressionColumn.this.m_cache.get(start));
                }
            } else {
                ExpressionColumn.this.invalidateCache(start, end);
                ExpressionColumn.this.fireColumnEvent(0, start, end);
            }
        }

        public void columnChanged(Column src, int idx, boolean prev) {
            this.columnChanged(idx, idx);
        }

        public void columnChanged(Column src, int idx, double prev) {
            this.columnChanged(idx, idx);
        }

        public void columnChanged(Column src, int idx, float prev) {
            this.columnChanged(idx, idx);
        }

        public void columnChanged(Column src, int type, int start, int end) {
            this.columnChanged(start, end);
        }

        public void columnChanged(Column src, int idx, int prev) {
            this.columnChanged(idx, idx);
        }

        public void columnChanged(Column src, int idx, long prev) {
            this.columnChanged(idx, idx);
        }

        public void columnChanged(Column src, int idx, Object prev) {
            this.columnChanged(idx, idx);
        }

        public void expressionChanged(Expression expr) {
            this.columnChanged(0, ExpressionColumn.this.m_cache.getRowCount() - 1);
            ExpressionColumn.this.init();
        }
    }
}

