/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import prefuse.data.io.AbstractTextTableReader;
import prefuse.data.io.DataIOException;
import prefuse.data.io.FixedWidthTextTableSchema;
import prefuse.data.io.TableReadListener;
import prefuse.data.parser.DataParseException;

public class FixedWidthTextTableReader
extends AbstractTextTableReader {
    private FixedWidthTextTableSchema m_schema;

    public FixedWidthTextTableReader(FixedWidthTextTableSchema schema) {
        super.setHasHeader(false);
        this.m_schema = schema;
    }

    public FixedWidthTextTableReader(String location) throws DataIOException {
        this(FixedWidthTextTableSchema.load(location));
    }

    public FixedWidthTextTableSchema getFixedWidthSchema() {
        return this.m_schema;
    }

    public void setFixedWidthSchema(FixedWidthTextTableSchema schema) {
        this.m_schema = schema;
    }

    protected void read(InputStream is, TableReadListener trl) throws IOException, DataParseException {
        String line;
        int lineno = 0;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            ++lineno;
            int i = 0;
            while (i < this.m_schema.getColumnCount()) {
                int idx0 = this.m_schema.getColumnStart(i);
                int idx1 = this.m_schema.getColumnEnd(i);
                trl.readValue(lineno, i + 1, line.substring(idx0, idx1));
                ++i;
            }
        }
    }

    protected ArrayList getColumnNames() {
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < this.m_schema.getColumnCount()) {
            names.add(this.m_schema.getColumnName(i));
            ++i;
        }
        return names;
    }
}

