/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Arrays;
import java.util.Date;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;
import prefuse.util.TimeLib;

public class DateColumn
extends AbstractColumn {
    private long[] m_values;
    private int m_size;

    public DateColumn() {
        this(Date.class, 0, 10, 0L);
    }

    public DateColumn(int nrows) {
        this(Date.class, nrows, nrows, 0L);
    }

    public DateColumn(Class type, int nrows) {
        this(type, nrows, nrows, 0L);
    }

    public DateColumn(Class type, int nrows, int capacity, long defaultValue) {
        super(type, TimeLib.getDate(type, defaultValue));
        if (!Date.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Column type must be an instance or subclass of java.util.Date.");
        }
        if (capacity < nrows) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new long[capacity];
        Arrays.fill(this.m_values, defaultValue);
        this.m_size = nrows;
    }

    public int getRowCount() {
        return this.m_size;
    }

    public void setMaximumRow(int nrows) {
        if (nrows > this.m_values.length) {
            int capacity = Math.max(3 * this.m_values.length / 2 + 1, nrows);
            long[] values = new long[capacity];
            System.arraycopy(this.m_values, 0, values, 0, this.m_size);
            Arrays.fill(values, this.m_size, capacity, ((Date)this.m_defaultValue).getTime());
            this.m_values = values;
        }
        this.m_size = nrows;
    }

    public boolean canSet(Class type) {
        if (type == null) {
            return false;
        }
        if (Number.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            return true;
        }
        return this.m_columnType.isAssignableFrom(type);
    }

    public Object get(int row) {
        return TimeLib.getDate(this.m_columnType, this.getLong(row));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(Object val, int row) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (val == null) throw new DataTypeException("Column does not accept null values");
        if (val instanceof Date) {
            this.setLong(((Date)val).getTime(), row);
            return;
        } else if (val instanceof Number) {
            this.setLong(((Number)val).longValue(), row);
            return;
        } else {
            if (!(val instanceof String)) throw new DataTypeException(val.getClass());
            this.setString((String)val, row);
        }
    }

    public long getLong(int row) throws DataTypeException {
        if (row < 0 || row > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        return this.m_values[row];
    }

    public void setLong(long val, int row) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (row < 0 || row >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        long prev = this.m_values[row];
        if (prev == val) {
            return;
        }
        this.m_values[row] = val;
        this.fireColumnEvent(row, prev);
    }

    public double getDouble(int row) throws DataTypeException {
        return this.getLong(row);
    }
}

