/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import prefuse.Display;
import prefuse.activity.Activity;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.ControlAdapter;

public class ZoomingPanControl
extends ControlAdapter {
    private boolean repaint = true;
    private boolean started = false;
    private Point mouseDown;
    private Point mouseCur;
    private Point mouseUp;
    private int dx;
    private int dy;
    private double d = 0.0;
    private double v0 = 75.0;
    private double d0 = 50.0;
    private double d1 = 400.0;
    private double s0 = 0.1;
    private UpdateActivity update = new UpdateActivity();
    private FinishActivity finish = new FinishActivity();

    public ZoomingPanControl() {
        this(true);
    }

    public ZoomingPanControl(boolean repaint) {
        this.repaint = repaint;
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            Display display = (Display)e.getComponent();
            display.setCursor(Cursor.getPredefinedCursor(13));
            this.mouseDown = e.getPoint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.mouseCur = e.getPoint();
            this.dx = this.mouseCur.x - this.mouseDown.x;
            this.dy = this.mouseCur.y - this.mouseDown.y;
            this.d = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
            if (!this.started) {
                Display display = (Display)e.getComponent();
                this.update.setDisplay(display);
                this.update.run();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.update.cancel();
            this.started = false;
            Display display = (Display)e.getComponent();
            this.mouseUp = e.getPoint();
            this.finish.setDisplay(display);
            this.finish.run();
            display.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class FinishActivity
    extends Activity {
        private Display display;
        private double scale;

        public FinishActivity() {
            super(1500L, 15L, 0L);
            this.setPacingFunction(new SlowInSlowOutPacer());
        }

        public void setDisplay(Display display) {
            this.display = display;
            this.scale = display.getTransform().getScaleX();
            double z = this.scale < 1.0 ? 1.0 / this.scale : this.scale;
            this.setDuration((long)(500.0 + 500.0 * Math.log(1.0 + z)));
        }

        protected void run(long elapsedTime) {
            double f = this.getPace(elapsedTime);
            double s = this.display.getTransform().getScaleX();
            double z = (f + (1.0 - f) * this.scale) / s;
            this.display.zoom(ZoomingPanControl.this.mouseUp, z);
            if (ZoomingPanControl.this.repaint) {
                this.display.repaint();
            }
        }
    }

    private class UpdateActivity
    extends Activity {
        private Display display;
        private long lastTime;

        public UpdateActivity() {
            super(-1L, 15L, 0L);
            this.lastTime = 0L;
        }

        public void setDisplay(Display display) {
            this.display = display;
        }

        protected void run(long elapsedTime) {
            double v;
            double s;
            double sx = this.display.getTransform().getScaleX();
            if (ZoomingPanControl.this.d <= ZoomingPanControl.this.d0) {
                s = 1.0;
                v = ZoomingPanControl.this.v0 * (ZoomingPanControl.this.d / ZoomingPanControl.this.d0);
            } else {
                s = ZoomingPanControl.this.d >= ZoomingPanControl.this.d1 ? ZoomingPanControl.this.s0 : Math.pow(ZoomingPanControl.this.s0, (ZoomingPanControl.this.d - ZoomingPanControl.this.d0) / (ZoomingPanControl.this.d1 - ZoomingPanControl.this.d0));
                v = ZoomingPanControl.this.v0;
            }
            s /= sx;
            double dd = v * (double)(elapsedTime - this.lastTime) / 1000.0;
            this.lastTime = elapsedTime;
            double deltaX = -dd * (double)ZoomingPanControl.this.dx / ZoomingPanControl.this.d;
            double deltaY = -dd * (double)ZoomingPanControl.this.dy / ZoomingPanControl.this.d;
            this.display.pan(deltaX, deltaY);
            if (s != 1.0) {
                this.display.zoom(ZoomingPanControl.this.mouseCur, s);
            }
            if (ZoomingPanControl.this.repaint) {
                this.display.repaint();
            }
        }
    }
}

