/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.OCLExpression;

public class PrimitiveTypesTest
extends AbstractTestSuite {
    public void test_unlimitedNaturalType() {
        OCLExpression expression = this.parse("package ecore context ETypedElement inv: self.upperBound endpackage");
        PrimitiveTypesTest.assertSame((Object)this.ocl.getEnvironment().getOCLStandardLibrary().getUnlimitedNatural(), (Object)expression.getType());
    }

    public void test_unlimitedValue() {
        OCLExpression expression = this.parse("package ecore context EClass inv: let x : UnlimitedNatural = * in x endpackage");
        PrimitiveTypesTest.assertSame((Object)this.ocl.getEnvironment().getOCLStandardLibrary().getUnlimitedNatural(), (Object)expression.getType());
        Object result = this.evaluate(expression);
        PrimitiveTypesTest.assertEquals((Object)-1, (Object)result);
    }

    public void test_unlimitedValueComparison() {
        this.helper.setContext((Object)((EClassifier)this.getOCLStandardLibrary().getUnlimitedNatural()));
        try {
            PrimitiveTypesTest.assertFalse((boolean)this.check(this.helper, 1, "2 = *"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "2 <> *"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "2 < *"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "2 <= *"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "* > 2"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "* >= 2"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "* = *"));
            PrimitiveTypesTest.assertFalse((boolean)this.check(this.helper, 1, "* <> *"));
            PrimitiveTypesTest.assertFalse((boolean)this.check(this.helper, 1, "* < *"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "* <= *"));
            PrimitiveTypesTest.assertFalse((boolean)this.check(this.helper, 1, "* > *"));
            PrimitiveTypesTest.assertTrue((boolean)this.check(this.helper, 1, "* >= *"));
        }
        catch (Exception e) {
            PrimitiveTypesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_unlimitedValueArithmetic_integers() {
        this.helper.setContext((Object)((EClassifier)this.getOCLStandardLibrary().getUnlimitedNatural()));
        try {
            this.assertInvalid(this.evaluate(this.helper, 1, "2 + *"));
        }
        catch (Exception e) {
            PrimitiveTypesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        try {
            this.assertInvalid(this.evaluate(this.helper, 1, "* + 2"));
        }
        catch (Exception e) {
            PrimitiveTypesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_unlimitedValueArithmetic_reals() {
        this.helper.setContext((Object)((EClassifier)this.getOCLStandardLibrary().getUnlimitedNatural()));
        try {
            this.assertInvalid(this.evaluate(this.helper, 1, "2.0 + *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "2.0 - *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "2.0 / *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "2.0 * *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "2.0.min(*)"));
            this.assertInvalid(this.evaluate(this.helper, 1, "2.0.max(*)"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* + 2.0"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* - 2.0"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* / 2.0"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* * 2.0"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.min(2.0)"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.max(2.0)"));
        }
        catch (Exception e) {
            PrimitiveTypesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_unlimitedValueArithmetic_naturals() {
        this.helper.setContext((Object)((EClassifier)this.getOCLStandardLibrary().getUnlimitedNatural()));
        try {
            this.assertInvalid(this.evaluate(this.helper, 1, "*.round()"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.floor()"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.abs()"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* + *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* - *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* / *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "* * *"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.min(*)"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.max(*)"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.mod(*)"));
            this.assertInvalid(this.evaluate(this.helper, 1, "*.div(*)"));
        }
        catch (Exception e) {
            PrimitiveTypesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_listOfEDataType_noInstanceClass() {
        EPackage testpkg = EcoreFactory.eINSTANCE.createEPackage();
        testpkg.setNsURI("http://www.eclipse.org/ocl/test/2008/testpkg");
        testpkg.setName("testpkg");
        testpkg.setNsPrefix("t");
        EClass testclass = EcoreFactory.eINSTANCE.createEClass();
        testclass.setName("Test");
        testpkg.getEClassifiers().add((Object)testclass);
        EDataType testdatatype = EcoreFactory.eINSTANCE.createEDataType();
        testdatatype.setName("Data");
        testpkg.getEClassifiers().add((Object)testdatatype);
        EAttribute testattr = EcoreFactory.eINSTANCE.createEAttribute();
        testattr.setName("data");
        testclass.getEStructuralFeatures().add((Object)testattr);
        testattr.setLowerBound(0);
        testattr.setUpperBound(-1);
        testattr.setEType((EClassifier)testdatatype);
        try {
            resourceSet.getPackageRegistry().put((Object)testpkg.getNsURI(), (Object)testpkg);
            this.helper.setContext((Object)testclass);
            this.helper.createInvariant("self.data->size() > 1");
        }
        catch (ParserException e) {
            PrimitiveTypesTest.fail((String)("Should not have failed to parse: " + e.getLocalizedMessage()));
        }
    }
}

