/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.core.OCLDebugTarget;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMRootEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMVirtualMachine;
import org.eclipse.ocl.examples.debug.vm.core.VMVariable;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.ocl.xtext.base.ui.model.BaseEditorCallback;
import org.eclipse.ocl.xtext.completeocl.ui.internal.CompleteOCLActivator;

public class DebuggerTests
extends XtextTestCase {
    private void checkEquals(String string, Object left, Object right) {
        if (!left.equals(right)) {
            System.out.println(String.valueOf(string) + " mismatch for " + left + " " + right);
        }
    }

    private void checkPosition(@NonNull IThread vmThread, int lineNumber, int charStart, int charEnd) throws DebugException {
        IStackFrame topStackFrame = vmThread.getTopStackFrame();
        this.checkEquals("lineNumber", lineNumber, topStackFrame.getLineNumber());
        this.checkEquals("charStart", charStart, topStackFrame.getCharStart());
        this.checkEquals("charEnd", charEnd, topStackFrame.getCharEnd());
    }

    private void checkVariable(@NonNull IThread vmThread, @NonNull String name, @Nullable Object expectedValue) throws DebugException {
        IStackFrame topStackFrame = vmThread.getTopStackFrame();
        IVariable[] variables = topStackFrame.getVariables();
        if (variables != null) {
            IVariable[] iVariableArray = variables;
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable variable = iVariableArray[n2];
                if (name.equals(variable.getName()) && variable instanceof VMVariable) {
                    Object valueObject = ((VMVariable)variable).getVmVar().valueObject;
                    this.checkEquals(name, expectedValue, valueObject);
                    return;
                }
                ++n2;
            }
        }
        System.out.println("Unknown variable '" + name + "'");
    }

    private void checkVariableEClass(@NonNull IThread vmThread, @NonNull String name, EClass expectedEClass) throws DebugException {
        IStackFrame topStackFrame = vmThread.getTopStackFrame();
        IVariable[] variables = topStackFrame.getVariables();
        if (variables != null) {
            IVariable[] iVariableArray = variables;
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable variable = iVariableArray[n2];
                if (name.equals(variable.getName()) && variable instanceof VMVariable) {
                    Object valueObject = ((VMVariable)variable).getVmVar().valueObject;
                    EClass valueEClass = ((EObject)valueObject).eClass();
                    this.checkEquals(name, expectedEClass, valueEClass);
                    return;
                }
                ++n2;
            }
        }
        System.out.println("Unknown variable '" + name + "'");
    }

    private void checkVariables(@NonNull IThread vmThread, String ... names) throws DebugException {
        ArrayList<String> expectedNames = new ArrayList<String>();
        if (names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                expectedNames.add(name);
                ++n2;
            }
        }
        Collections.sort(expectedNames);
        IStackFrame topStackFrame = vmThread.getTopStackFrame();
        IVariable[] variables = topStackFrame.getVariables();
        ArrayList<String> actualNames = new ArrayList<String>();
        if (variables != null) {
            IVariable[] iVariableArray = variables;
            int n = variables.length;
            int n3 = 0;
            while (n3 < n) {
                IVariable variable = iVariableArray[n3];
                actualNames.add(variable.getName());
                ++n3;
            }
        }
        Collections.sort(actualNames);
        this.checkEquals("variables", expectedNames, actualNames);
    }

    public static @NonNull TestFile copyFile(@NonNull TestProject testProject, @NonNull URIConverter uriConverter, @NonNull URI sourceURI) throws IOException {
        InputStream inputStream = uriConverter.createInputStream(sourceURI);
        String lastSegment = sourceURI.lastSegment();
        assert (lastSegment != null);
        return testProject.getOutputFile(lastSegment, inputStream);
    }

    protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(@NonNull IProject iProject, @NonNull Constraint constraint, @NonNull EObject eObject) throws CoreException {
        URI contextURI = EcoreUtil.getURI((EObject)eObject);
        URI constraintURI = EcoreUtil.getURI((EObject)constraint);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.ocl.examples.debug.launching.OCLLaunchConfigurationDelegate");
        ILaunchConfigurationWorkingCopy launchConfiguration = launchConfigurationType.newInstance((IContainer)iProject, constraint.getName());
        launchConfiguration.setAttribute("constraint", constraintURI.toString());
        launchConfiguration.setAttribute("context", contextURI.toString());
        return launchConfiguration;
    }

    protected @NonNull URI getModelsURI(@NonNull String filePath) {
        return URI.createPlatformResourceURI((String)(String.valueOf(this.getTestBundleName()) + "/models/" + filePath), (boolean)true);
    }

    public void testDebugger_Launch() throws Exception {
        TestUIUtil.closeIntro();
        TestUIUtil.enableSwitchToDebugPerspectivePreference();
        Injector injector = CompleteOCLActivator.getInstance().getInjector("org.eclipse.ocl.xtext.completeocl.CompleteOCL");
        ((BaseEditorCallback)injector.getInstance(BaseEditorCallback.class)).setDontAskForNatureAgain();
        TestProject testProject = this.getTestProject();
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)new ProjectMap(false), null);
        URIConverter uriConverter = ocl.getResourceSet().getURIConverter();
        TestFile xmiFile = DebuggerTests.copyFile(testProject, uriConverter, DebuggerTests.getTestModelURI("models/ecore/RoyalAndLoyal.xmi"));
        TestFile ecoreFile = DebuggerTests.copyFile(testProject, uriConverter, DebuggerTests.getTestModelURI("models/ecore/RoyalAndLoyal.ecore"));
        TestFile oclFile = DebuggerTests.copyFile(testProject, uriConverter, DebuggerTests.getTestModelURI("models/ecore/RoyalAndLoyal.ocl"));
        Resource xmiResource = ocl.getResourceSet().getResource(xmiFile.getURI(), true);
        EObject xmiRoot = (EObject)ClassUtil.nonNullState((Object)((EObject)xmiResource.getContents().get(0)));
        DebuggerTests.assertNoResourceErrors("Load failed", xmiResource);
        DebuggerTests.assertNoUnresolvedProxies("Unresolved proxies", xmiResource);
        DebuggerTests.assertNoValidationErrors("Validation errors", xmiRoot);
        Resource oclResource = (Resource)ClassUtil.nonNullState((Object)ocl.getResourceSet().getResource(oclFile.getURI(), true));
        DebuggerTests.assertNoResourceErrors("Load failed", oclResource);
        DebuggerTests.assertNoUnresolvedProxies("Unresolved proxies", oclResource);
        DebuggerTests.assertNoValidationErrors("Validation errors", (EObject)ClassUtil.nonNullState((Object)((EObject)oclResource.getContents().get(0))));
        EStructuralFeature ref_RandL_Customer = xmiRoot.eClass().getEStructuralFeature("ref_RandL_Customer");
        List customers = (List)xmiRoot.eGet(ref_RandL_Customer);
        EObject eObject = (EObject)customers.get(0);
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        Class customerClass = (Class)ClassUtil.nonNullState((Object)((Class)environmentFactory.getASOf(Class.class, (EObject)eObject.eClass())));
        Iterable customerInvariants = environmentFactory.getMetamodelManager().getAllInvariants((Type)customerClass);
        Constraint constraint = (Constraint)ClassUtil.nonNullState((Object)((Constraint)NameUtil.getNameable((Iterable)customerInvariants, (String)"invariant_sizesAgree")));
        ThreadLocalExecutor.resetEnvironmentFactory();
        IProject iProject = testProject.getIProject();
        ILaunchConfigurationWorkingCopy launchConfiguration = this.createLaunchConfiguration(iProject, constraint, eObject);
        launchConfiguration.doSave();
        TestUIUtil.flushEvents();
        ILaunch launch = launchConfiguration.launch("debug", null);
        assert (launch != null);
        OCLDebugTarget debugTarget = (OCLDebugTarget)launch.getDebugTarget();
        try {
            OCLVMVirtualMachine vm = (OCLVMVirtualMachine)debugTarget.getVM();
            OCLVMRootEvaluationEnvironment vmRootEvaluationEnvironment = (OCLVMRootEvaluationEnvironment)vm.getEvaluationEnv();
            assert (vmRootEvaluationEnvironment != null);
            ExpressionInOCL asExpression = (ExpressionInOCL)vmRootEvaluationEnvironment.getDebuggableElement();
            VariableDeclaration selfVariable = PivotUtil.getOwnedContext((ExpressionInOCL)asExpression);
            IThread vmThread = debugTarget.getThreads()[0];
            assert (vmThread != null);
            TestUIUtil.waitForSuspended(vmThread);
            TestUIUtil.waitForNotStepping(vmThread);
            this.checkPosition(vmThread, 263, 11364, 11368);
            this.checkVariables(vmThread, "$pc", "self");
            this.checkVariableEClass(vmThread, "$pc", PivotPackage.Literals.VARIABLE_EXP);
            this.checkVariable(vmThread, "self", vmRootEvaluationEnvironment.getValueOf((TypedElement)selfVariable));
            vmThread.stepInto();
            TestUIUtil.waitForSuspended(vmThread);
            this.checkPosition(vmThread, 263, 11369, 11377);
            this.checkVariables(vmThread, "$pc", "self", "$ownedSource");
            this.checkVariableEClass(vmThread, "$pc", PivotPackage.Literals.PROPERTY_CALL_EXP);
            this.checkVariable(vmThread, "self", vmRootEvaluationEnvironment.getValueOf((TypedElement)selfVariable));
            vmThread.stepInto();
            TestUIUtil.waitForSuspended(vmThread);
            this.checkPosition(vmThread, 263, 11379, 11385);
            this.checkVariables(vmThread, "$pc", "self", "$ownedSource");
            this.checkVariableEClass(vmThread, "$pc", PivotPackage.Literals.OPERATION_CALL_EXP);
            this.checkVariable(vmThread, "self", vmRootEvaluationEnvironment.getValueOf((TypedElement)selfVariable));
            vmThread.stepInto();
            TestUIUtil.waitForSuspended(vmThread);
            this.checkPosition(vmThread, 264, 11390, 11394);
            this.checkVariables(vmThread, "$pc", "self");
            this.checkVariableEClass(vmThread, "$pc", PivotPackage.Literals.VARIABLE_EXP);
            this.checkVariable(vmThread, "self", vmRootEvaluationEnvironment.getValueOf((TypedElement)selfVariable));
            vmThread.stepInto();
            TestUIUtil.waitForSuspended(vmThread);
            this.checkPosition(vmThread, 264, 11395, 11400);
            this.checkVariables(vmThread, "$pc", "self", "$ownedSource");
            this.checkVariableEClass(vmThread, "$pc", PivotPackage.Literals.PROPERTY_CALL_EXP);
            this.checkVariable(vmThread, "self", vmRootEvaluationEnvironment.getValueOf((TypedElement)selfVariable));
            vmThread.stepInto();
            TestUIUtil.waitForSuspended(vmThread);
            this.checkPosition(vmThread, 266, 11449, 11463);
            this.checkVariables(vmThread, "$pc", "self");
            this.checkVariableEClass(vmThread, "$pc", PivotPackage.Literals.VARIABLE_EXP);
            this.checkVariable(vmThread, "self", vmRootEvaluationEnvironment.getValueOf((TypedElement)selfVariable));
            vmThread.stepInto();
            TestUIUtil.waitForSuspended(vmThread);
            this.checkPosition(vmThread, 266, 11464, 11469);
            this.checkVariables(vmThread, "$pc", "$ownedSource", "i_CustomerCard");
            this.checkVariableEClass(vmThread, "$pc", PivotPackage.Literals.PROPERTY_CALL_EXP);
            vmThread.stepInto();
            TestUIUtil.waitForSuspended(vmThread);
            this.checkPosition(vmThread, 266, 11472, 11476);
            this.checkVariables(vmThread, "$pc", "i_CustomerCard");
            this.checkVariableEClass(vmThread, "$pc", PivotPackage.Literals.BOOLEAN_LITERAL_EXP);
            vmThread.stepInto();
            TestUIUtil.waitForSuspended(vmThread);
            this.checkPosition(vmThread, 266, 11470, 11471);
            this.checkVariables(vmThread, "$pc", "$ownedSource", "$ownedArguments[0]", "i_CustomerCard");
            this.checkVariableEClass(vmThread, "$pc", PivotPackage.Literals.OPERATION_CALL_EXP);
            vmThread.stepInto();
            TestUIUtil.waitForSuspended(vmThread);
            this.checkPosition(vmThread, 268, 11485, 11491);
            this.checkVariables(vmThread, "$pc", "self", "$ownedSource");
            this.checkVariableEClass(vmThread, "$pc", PivotPackage.Literals.OPERATION_CALL_EXP);
            this.checkVariable(vmThread, "self", vmRootEvaluationEnvironment.getValueOf((TypedElement)selfVariable));
            vmThread.stepInto();
            TestUIUtil.waitForSuspended(vmThread);
            this.checkPosition(vmThread, 264, 11388, 11389);
            this.checkVariables(vmThread, "$pc", "self", "$ownedSource", "$ownedArguments[0]");
            this.checkVariableEClass(vmThread, "$pc", PivotPackage.Literals.OPERATION_CALL_EXP);
            this.checkVariable(vmThread, "self", vmRootEvaluationEnvironment.getValueOf((TypedElement)selfVariable));
            vmThread.stepInto();
            TestUIUtil.waitForSuspended(vmThread);
            this.checkPosition(vmThread, 263, 11364, 11491);
            this.checkVariables(vmThread, "$pc", "self", "$ownedBody");
            this.checkVariableEClass(vmThread, "$pc", PivotPackage.Literals.EXPRESSION_IN_OCL);
            this.checkVariable(vmThread, "self", vmRootEvaluationEnvironment.getValueOf((TypedElement)selfVariable));
            vmThread.stepInto();
            boolean hasTerminated = false;
            int i = 0;
            while (i < 10) {
                TestUIUtil.flushEvents();
                Thread.sleep(100L);
                if (vmThread.isTerminated()) {
                    hasTerminated = true;
                    break;
                }
                ++i;
            }
            if (!hasTerminated) {
                IStackFrame topStackFrame = vmThread.getTopStackFrame();
                IVariable[] variables = topStackFrame.getVariables();
                if (variables != null) {
                    IVariable[] iVariableArray = variables;
                    int n = variables.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVariable variable = iVariableArray[n2];
                        if ("$invalid".equals(variable.getName()) && variable instanceof VMVariable) {
                            Object valueObject = ((VMVariable)variable).getVmVar().valueObject;
                            throw (Exception)valueObject;
                        }
                        ++n2;
                    }
                }
                TestCase.fail((String)"Failed to terminate");
            }
            DebuggerTests.assertEquals((int)0, (int)vm.getExitCode());
            ocl.dispose();
        }
        finally {
            debugTarget.killAfterTest();
        }
    }
}

