/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.serializer.SerializationBuilder;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;

public class SerializationBuilderTests
extends XtextTestCase {
    private static final @NonNull String WE = SerializationBuilder.WRAP_END;
    private static final @NonNull String WH = SerializationBuilder.WRAP_HERE;
    private static final @NonNull String SS = SerializationBuilder.SOFT_SPACE;
    private static final @NonNull String WBA = SerializationBuilder.WRAP_BEGIN_ALL;
    private static final @NonNull String WA = SerializationBuilder.WRAP_ANCHOR;
    private static final @NonNull String POP = SerializationBuilder.POP;
    private static final @NonNull String NL = SerializationBuilder.NEW_LINE;
    private static final @NonNull String PUSH = SerializationBuilder.PUSH;

    public void appends(@NonNull SerializationBuilder s, String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull String string = stringArray[n2];
            s.append(string);
            ++n2;
        }
    }

    public @NonNull String concat(String ... strings) {
        StringBuilder s = new StringBuilder();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull String string = stringArray[n2];
            s.append(string);
            ++n2;
        }
        return s.toString();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        SerializationBuilder.reset();
    }

    public void testSerializationBuilder_Indent() {
        String nl = "\n";
        String ht = "\t";
        String ht2 = String.valueOf(ht) + ht;
        String ht3 = String.valueOf(ht2) + ht;
        String a1 = "a";
        String b2 = "bb";
        String c3 = "ccc";
        String x2 = "xx";
        String y2 = "yy";
        String z2 = "zz";
        SerializationBuilder s = new SerializationBuilder(nl, ht);
        this.appends(s, x2, PUSH, y2, NL, z2, POP);
        String concat1 = this.concat(x2, y2, nl, ht, z2);
        SerializationBuilderTests.assertEquals((String)(String.valueOf(concat1) + nl), (String)(String.valueOf(s.toString()) + "\n"));
        this.appends(s, PUSH, a1, NL, PUSH, b2, PUSH, NL, c3, NL, POP, POP, POP);
        String concat2 = this.concat(a1, nl, ht2, b2, nl, ht3, c3);
        s.close();
        SerializationBuilderTests.assertEquals((String)(String.valueOf(concat1) + concat2 + nl), (String)s.toString());
    }

    public void testSerializationBuilder_NewLine() {
        String nl = "\r\n";
        SerializationBuilder s = new SerializationBuilder(nl, "\t");
        SerializationBuilderTests.assertEquals((String)"", (String)s.toString());
        this.appends(s, NL);
        SerializationBuilderTests.assertEquals((String)nl, (String)s.toString());
        this.appends(s, NL);
        SerializationBuilderTests.assertEquals((String)(String.valueOf(nl) + nl), (String)s.toString());
        this.appends(s, NL);
        SerializationBuilderTests.assertEquals((String)(String.valueOf(nl) + nl + nl), (String)s.toString());
        s.close();
    }

    public void testSerializationBuilder_Wrap() {
        String a10 = "aaaaaaaaaa";
        String b12 = "bbbbbbbbbbbb";
        String c14 = "cccccccccccccc";
        String d16 = "dddddddddddddddd";
        String e18 = "eeeeeeeeeeeeeeeeee";
        String f20 = "ffffffffffffffffffff";
        String nl = "\n";
        String ht = "\t";
        SerializationBuilder s = new SerializationBuilder(nl, ht, 15, 8);
        this.appends(s, a10, WH, "(", WBA, b12, WH, "(", WBA, c14, WH, "(", WBA, d16, WH, "(", WBA, e18, WH, "(", WBA, f20, WH, ")", WE, ")", WE, ")", WE, ")", WE, ")", WE, NL);
        String concat = this.concat(a10, nl, this.spaces(0), "(", b12, nl, this.spaces(1), "(", c14, nl, this.spaces(2), "(", d16, nl, this.spaces(3), "(", e18, nl, this.spaces(4), "(", f20, nl, this.spaces(5), ")", ")", ")", ")", ")");
        SerializationBuilderTests.assertEquals((String)(String.valueOf(concat) + nl), (String)s.toString());
        s.close();
    }

    private @NonNull String spaces(int count) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < count) {
            s.append(' ');
            ++i;
        }
        return s.toString();
    }
}

