/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.standalone.validity;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporterDescriptor;
import org.eclipse.ocl.examples.emf.validation.validity.export.ValidityExporterRegistry;
import org.eclipse.ocl.examples.standalone.StandaloneApplication;
import org.eclipse.ocl.examples.standalone.StandaloneCommand;
import org.eclipse.ocl.examples.standalone.StandaloneResponse;
import org.eclipse.ocl.examples.standalone.messages.StandaloneMessages;
import org.eclipse.ocl.examples.standalone.validity.StandaloneValidityManager;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.ocl.xtext.completeocl.utilities.CompleteOCLLoader;

public class ValidateCommand
extends StandaloneCommand {
    private static final Logger logger = Logger.getLogger(ValidateCommand.class);
    public final @NonNull ExporterToken exporterToken = new ExporterToken();
    public final @NonNull ModelToken modelToken = new ModelToken();
    public final @NonNull OutputToken outputToken = new OutputToken();
    public final @NonNull RulesToken rulesToken = new RulesToken();
    public final @NonNull UsingToken usingToken = new UsingToken();

    protected static String getCheckedFileName(@NonNull String string) {
        URI uri = URI.createURI((String)string);
        string = uri.isFile() ? uri.toFileString() : string;
        boolean exists = ValidateCommand.getURIConverter().exists(uri, null);
        if (exists) {
            return string;
        }
        logger.error((Object)(String.valueOf(StandaloneMessages.OCLArgumentAnalyzer_ModelFile) + uri + StandaloneMessages.OCLArgumentAnalyzer_NotExist));
        return null;
    }

    private static URI getFileUri(@NonNull String fileName) {
        try {
            File file = new File(fileName).getCanonicalFile();
            Path filePath = new Path(file.getAbsolutePath());
            URI fileUri = ValidateCommand.isRelativePath((IPath)filePath) ? URI.createPlatformResourceURI((String)filePath.toString(), (boolean)true) : URI.createFileURI((String)filePath.toString());
            return fileUri;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isRelativePath(IPath path) {
        if (ResourcesPlugin.getPlugin() != null) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            return resource != null && resource.exists();
        }
        return false;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    public ValidateCommand(@NonNull StandaloneApplication standaloneApplication) {
        super(standaloneApplication, "validate", StandaloneMessages.ValidateCommand_Help);
        this.modelToken.setIsRequired();
        this.rulesToken.setIsRequired();
        this.addToken(this.modelToken);
        this.addToken(this.rulesToken);
        this.addToken(this.outputToken);
        this.addToken(this.exporterToken);
        this.addToken(this.usingToken);
    }

    @Override
    public @NonNull StandaloneResponse execute(@NonNull Map<StandaloneCommand.CommandToken, List<String>> token2strings) {
        Resource modelResource;
        this.standaloneApplication.doCompleteOCLSetup();
        String modelFileName = this.modelToken.getModelFileName(token2strings);
        List<String> oclFileNames = this.rulesToken.getOCLFileNames(token2strings);
        URI modelURI = URI.createURI((String)modelFileName, (boolean)true);
        if (!modelURI.isPlatform()) {
            modelURI = ValidateCommand.getFileUri(modelFileName);
        }
        if ((modelResource = this.standaloneApplication.loadModelFile(modelURI)) == null) {
            logger.error((Object)MessageFormat.format(StandaloneMessages.OCLValidatorApplication_ModelLoadProblem, modelFileName));
            return StandaloneResponse.FAIL;
        }
        if (!this.processResources(modelFileName, oclFileNames)) {
            logger.error((Object)StandaloneMessages.OCLValidatorApplication_Aborted);
            return StandaloneResponse.FAIL;
        }
        if (ThreadLocalExecutor.basicGetEnvironmentFactory() == null) {
            logger.error((Object)StandaloneMessages.OCLValidatorApplication_Aborted);
            return StandaloneResponse.FAIL;
        }
        StandaloneValidityManager validityManager = this.initiateValidityManager(this.standaloneApplication.getResourceSet(), token2strings);
        if (validityManager != null) {
            this.validate(validityManager);
            File outputFile = this.outputToken.getOutputFile(token2strings);
            this.exportValidationResults(validityManager.getRootNode(), outputFile, token2strings);
        }
        return StandaloneResponse.OK;
    }

    private void exportValidationResults(@NonNull RootNode rootNode, @Nullable File outputFile, @NonNull Map<StandaloneCommand.CommandToken, List<String>> token2strings) {
        block13: {
            IValidityExporter selectedExporter = this.exporterToken.getExporter(token2strings);
            if (selectedExporter != null && rootNode != null) {
                Appendable s = null;
                try {
                    try {
                        s = outputFile != null ? new FileWriter(outputFile) : DEFAULT_OUTPUT_STREAM;
                        selectedExporter.export(s, rootNode, outputFile != null ? outputFile.toString() : null);
                    }
                    catch (IOException e) {
                        logger.error((Object)StandaloneMessages.OCLValidatorApplication_ExportProblem, (Throwable)e);
                        if (s == DEFAULT_OUTPUT_STREAM || !(s instanceof OutputStreamWriter)) break block13;
                        try {
                            ((OutputStreamWriter)s).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (s != DEFAULT_OUTPUT_STREAM && s instanceof OutputStreamWriter) {
                        try {
                            ((OutputStreamWriter)s).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    private @NonNull StandaloneValidityManager initiateValidityManager(@NonNull ResourceSet resourceSet, @NonNull Map<StandaloneCommand.CommandToken, List<String>> token2strings) {
        StandaloneValidityManager validityManager = new StandaloneValidityManager();
        validityManager.setRunJavaConstraints(this.usingToken.doRunJavaConstraints(token2strings));
        validityManager.setRunOCLConstraints(this.usingToken.doRunOCLConstraints(token2strings));
        validityManager.setRunUMLConstraints(this.usingToken.doRunUMLConstraints(token2strings));
        validityManager.setInput(resourceSet);
        return validityManager;
    }

    private boolean processResources(@NonNull String modelFilePath, @NonNull List<String> oclFileNames) {
        boolean allOk = true;
        CompleteOCLLoader helper = new CompleteOCLLoader(this.standaloneApplication.getEnvironmentFactory()){

            protected boolean error(@NonNull String primaryMessage, @Nullable String detailMessage) {
                logger.error((Object)(String.valueOf(primaryMessage) + detailMessage));
                return false;
            }
        };
        for (String oclFileName : oclFileNames) {
            URI oclURI = URI.createURI((String)oclFileName, (boolean)true);
            if (!oclURI.isPlatform()) {
                oclURI = ValidateCommand.getFileUri(oclFileName);
            }
            if (allOk && oclURI == null) {
                logger.error((Object)MessageFormat.format(StandaloneMessages.OCLValidatorApplication_OclUriProblem, oclFileName));
                allOk = false;
            }
            try {
                Resource oclResource;
                if (!allOk || (oclResource = helper.loadResource(oclURI)) != null) continue;
                logger.error((Object)MessageFormat.format(StandaloneMessages.OCLValidatorApplication_OclLoadProblem, oclFileName));
                allOk = false;
            }
            catch (Throwable e) {
                logger.error((Object)MessageFormat.format(StandaloneMessages.OCLValidatorApplication_OclLoadProblem, oclFileName));
                allOk = false;
            }
        }
        if (allOk && !helper.loadMetamodels()) {
            logger.error((Object)StandaloneMessages.OCLValidatorApplication_MetamodelsLoadProblem);
            allOk = false;
        }
        helper.installPackages();
        helper.dispose();
        return allOk;
    }

    private void validate(@NonNull StandaloneValidityManager validityManager) {
        validityManager.runValidation();
    }

    protected static final class ExporterComparator
    implements Comparator<IValidityExporterDescriptor> {
        public static final @NonNull ExporterComparator INSTANCE = new ExporterComparator();

        protected ExporterComparator() {
        }

        @Override
        public int compare(IValidityExporterDescriptor o1, IValidityExporterDescriptor o2) {
            String n1 = o1.getExporterType();
            String n2 = o2.getExporterType();
            return n1.compareTo(n2);
        }
    }

    public static class ExporterToken
    extends StandaloneCommand.StringToken {
        public ExporterToken() {
            super("-exporter", StandaloneMessages.ValidateCommand_Exporter_Help);
        }

        @Override
        public boolean check(@NonNull List<String> strings) {
            return this.getExporter(strings) != null;
        }

        @Override
        public @Nullable String getArgsHelp() {
            ArrayList exporters = new ArrayList(ValidityExporterRegistry.INSTANCE.getRegisteredExtensions());
            Collections.sort(exporters, ExporterComparator.INSTANCE);
            StringBuilder s = new StringBuilder();
            for (IValidityExporterDescriptor exporter : exporters) {
                if (s.length() > 0) {
                    s.append("|");
                }
                s.append(exporter.getExporterType());
            }
            return s.toString();
        }

        private @Nullable IValidityExporter getExporter(@NonNull List<String> strings) {
            if (strings.size() <= 0) {
                return null;
            }
            String string = strings.get(0);
            return ValidityExporterRegistry.INSTANCE.getExporter(string);
        }

        public @Nullable IValidityExporter getExporter(@NonNull Map<StandaloneCommand.CommandToken, List<String>> token2strings) {
            List<String> strings = token2strings.get(this);
            if (strings == null) {
                return null;
            }
            return this.getExporter(strings);
        }
    }

    public static class ModelToken
    extends StandaloneCommand.StringToken {
        public ModelToken() {
            super("-model", StandaloneMessages.ValidateCommand_Model_Help);
        }

        @Override
        public boolean check(@NonNull List<String> strings) {
            return this.getModelFileName(strings) != null;
        }

        @Override
        public @Nullable String getArgsHelp() {
            return "<file-name>";
        }

        private @Nullable String getModelFileName(@NonNull List<String> strings) {
            if (strings.size() <= 0) {
                return null;
            }
            String string = strings.get(0);
            return ValidateCommand.getCheckedFileName(string);
        }

        public @Nullable String getModelFileName(@NonNull Map<StandaloneCommand.CommandToken, List<String>> token2strings) {
            List<String> strings = token2strings.get(this);
            if (strings == null) {
                return null;
            }
            return this.getModelFileName(strings);
        }
    }

    public static class OutputToken
    extends StandaloneCommand.StringToken {
        public OutputToken() {
            super("-output", StandaloneMessages.ValidateCommand_Output_Help);
        }

        @Override
        public boolean check(@NonNull List<String> strings) {
            return this.getOutputFile(strings) != null;
        }

        @Override
        public @Nullable String getArgsHelp() {
            return "<file-name>";
        }

        private @Nullable File getOutputFile(@NonNull List<String> strings) {
            block7: {
                if (strings.size() <= 0) {
                    return null;
                }
                String string = strings.get(0);
                try {
                    File file = new File(string).getCanonicalFile();
                    if (file.exists()) {
                        if (file.isFile()) {
                            file.delete();
                        } else {
                            logger.error((Object)(String.valueOf(StandaloneMessages.OCLArgumentAnalyzer_OutputFile) + file.getAbsolutePath() + StandaloneMessages.OCLArgumentAnalyzer_NotFile));
                        }
                    }
                    if (file.exists()) break block7;
                    File outputFolder = file.getParentFile();
                    if (!outputFolder.exists()) {
                        logger.error((Object)(String.valueOf(StandaloneMessages.OCLArgumentAnalyzer_OutputDir) + outputFolder.getAbsolutePath() + StandaloneMessages.OCLArgumentAnalyzer_NotExist));
                        break block7;
                    }
                    return file;
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            return null;
        }

        public File getOutputFile(@NonNull Map<StandaloneCommand.CommandToken, List<String>> token2strings) {
            List<String> strings = token2strings.get(this);
            if (strings == null) {
                return null;
            }
            return this.getOutputFile(strings);
        }
    }

    public static class RulesToken
    extends StandaloneCommand.CommandToken {
        private static final Object TEXT_FILE_EXTENSION = "txt";
        private static final Object OCL_FILE_EXTENSION = "ocl";

        public RulesToken() {
            super("-rules", StandaloneMessages.ValidateCommand_Rules_Help);
        }

        @Override
        public boolean check(@NonNull List<String> strings) {
            strings.size();
            for (String string : strings) {
                String checkedName = ValidateCommand.getCheckedFileName(string);
                if (checkedName != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public int parseArgument(@NonNull List<String> strings, @NonNull String @NonNull [] arguments, int i) {
            if (i < arguments.length) {
                String argument = arguments[i++];
                this.checkOclFile(strings, argument);
                return i;
            }
            logger.error((Object)("No argument for '" + this.name + "'"));
            return -1;
        }

        private void checkOclFile(@NonNull List<String> strings, @NonNull String argument) {
            URI uri = URI.createURI((String)argument);
            argument = uri.isFile() ? uri.toFileString() : argument;
            boolean ignored = false;
            URIConverter uriConverter = ValidateCommand.getURIConverter();
            boolean exists = uriConverter.exists(uri, null);
            String fileExtension = uri.fileExtension();
            if (TEXT_FILE_EXTENSION.equals(fileExtension.toLowerCase())) {
                this.extractOCLUris(strings, uri);
            } else if (OCL_FILE_EXTENSION.equals(fileExtension.toLowerCase())) {
                if (!exists) {
                    logger.warn((Object)(String.valueOf(StandaloneMessages.OCLArgumentAnalyzer_OCLResource) + " " + uri + StandaloneMessages.OCLArgumentAnalyzer_NotExist));
                    ignored = true;
                } else {
                    strings.add(uri.toString());
                }
            } else {
                logger.warn((Object)(String.valueOf(StandaloneMessages.OCLArgumentAnalyzer_FileExt) + uri.lastSegment() + StandaloneMessages.OCLArgumentAnalyzer_ExtensionPb));
                ignored = true;
            }
            if (ignored) {
                logger.warn((Object)(String.valueOf(StandaloneMessages.OCLArgumentAnalyzer_OCLFile) + " " + uri + StandaloneMessages.OCLArgumentAnalyzer_ignored));
            }
        }

        private void extractOCLUris(@NonNull List<@NonNull String> strings, @NonNull URI txtURI) {
            try {
                InputStream inputStream = ValidateCommand.getURIConverter().createInputStream(txtURI);
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line = reader.readLine();
                while (line != null) {
                    URI childURI = URI.createURI((String)line).resolve(txtURI);
                    this.checkOclFile(strings, childURI.toString());
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (FileNotFoundException e) {
                logger.error((Object)MessageFormat.format(StandaloneMessages.OCLArgumentAnalyzer_OCLFileNotFound, txtURI));
            }
            catch (IOException e) {
                logger.warn((Object)e.getMessage());
            }
        }

        @Override
        public @Nullable String getArgsHelp() {
            return "<file-name>";
        }

        public @NonNull List<String> getOCLFileNames(@NonNull Map<StandaloneCommand.CommandToken, List<String>> token2strings) {
            List<String> strings = token2strings.get(this);
            if (strings == null) {
                return Collections.emptyList();
            }
            return strings;
        }
    }

    public static class UsingToken
    extends StandaloneCommand.StringToken {
        private static final String ALL_LOCATORS = "all";
        private static final String OCL_LOCATOR = "ocl";
        private static final String JAVA_LOCATOR = "java";
        private static final String UML_LOCATOR = "uml";

        public UsingToken() {
            super("-using", StandaloneMessages.ValidateCommand_Using_Help);
        }

        @Override
        public boolean check(@NonNull List<String> locators) {
            for (String locator : locators) {
                if (ALL_LOCATORS.equals(locator) || JAVA_LOCATOR.equals(locator) || OCL_LOCATOR.equals(locator) || UML_LOCATOR.equals(locator)) continue;
                logger.error((Object)("Unknown locator '" + locator + "'"));
                return false;
            }
            return true;
        }

        public boolean doRunJavaConstraints(@NonNull Map<StandaloneCommand.CommandToken, List<String>> token2strings) {
            List<String> strings = token2strings.get(this);
            return strings == null || strings.contains(JAVA_LOCATOR) || strings.contains(ALL_LOCATORS);
        }

        public boolean doRunOCLConstraints(@NonNull Map<StandaloneCommand.CommandToken, List<String>> token2strings) {
            List<String> strings = token2strings.get(this);
            return strings == null || strings.contains(OCL_LOCATOR) || strings.contains(ALL_LOCATORS);
        }

        public boolean doRunUMLConstraints(@NonNull Map<StandaloneCommand.CommandToken, List<String>> token2strings) {
            List<String> strings = token2strings.get(this);
            return strings == null || strings.contains(UML_LOCATOR) || strings.contains(ALL_LOCATORS);
        }

        @Override
        public @Nullable String getArgsHelp() {
            return "all|java|ocl|uml";
        }

        @Override
        public boolean isSingleton() {
            return false;
        }

        @Override
        public int parseArgument(@NonNull List<String> strings, @NonNull String @NonNull [] arguments, int i) {
            if (i < arguments.length) {
                String locator;
                String[] locators;
                String argument = arguments[i++];
                String[] stringArray = locators = argument.split(",");
                int n = locators.length;
                int n2 = 0;
                while (n2 < n) {
                    locator = stringArray[n2];
                    if (!(ALL_LOCATORS.equals(locator) || JAVA_LOCATOR.equals(locator) || OCL_LOCATOR.equals(locator) || UML_LOCATOR.equals(locator))) {
                        logger.error((Object)("Unknown locator '" + locator + "'"));
                        return -1;
                    }
                    ++n2;
                }
                stringArray = locators;
                n = locators.length;
                n2 = 0;
                while (n2 < n) {
                    locator = stringArray[n2];
                    strings.add(locator);
                    ++n2;
                }
                return i;
            }
            logger.error((Object)("No argument for '" + this.name + "'"));
            return -1;
        }
    }
}

