/*******************************************************************************
 * Copyright (c) 2006 - 2007 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     CEA LIST - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.languages.cpp.view.panels;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.transformation.base.utils.CommandSupport;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.util.UMLUtil;


/**
 * Panel displayed when a PrimitiveType is selected
 * @deprecated This view will be replaced by an XWT view for the C++ profile
 */
@Deprecated
public class CppPrimitiveTypePanel extends CppAbstractPanel {

	// document used by the viewer for definition of the type
	@SuppressWarnings("unused")
	private SourceViewer typeViewer;

	private Group typeGroup;

	private IDocument typeDocument;

	// Current selection
	private PrimitiveType selectedPType;

	public CppPrimitiveTypePanel(Composite parent, int style) {
		super(parent, style);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see com.cea.accordcpp.core.ui.panels.AccordCppAbstractPanel#getSelectedElement()
	 */
	@Override
	public PrimitiveType getSelectedElement() {
		return selectedPType;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see com.cea.accordcpp.core.ui.panels.AccordCppAbstractPanel#setSelectedElement(java.lang.Element)
	 */
	@Override
	public void setSelectedElement(Element newElement) {
		super.setSelectedElement(newElement);
		if (newElement instanceof PrimitiveType) {
			this.selectedPType = (PrimitiveType) newElement;
		}
		else {
			throw new RuntimeException("bad selection: " + newElement + " should be an uml2 PrimitiveType");
		}
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see com.cea.accorduml.ui.views.panels.AccordUMLAbstractPanel#createContentHI()
	 */
	@Override
	public Control createContent() {

		// /////////////////////////////////////////////////////////////////////
		// Create save reset buttons with superclass method
		// /////////////////////////////////////////////////////////////////////
		createSaveResetButtons();

		// /////////////////////////////////////////////////////////////////////
		// Type definition text area
		// /////////////////////////////////////////////////////////////////////

		typeDocument = createDocumentC();
		typeGroup = createGroup(this, "Type definition", buttonSave, null, true, 0, 0, true);
		// Use CDT CEditor coloration
		typeViewer = createViewerC(typeDocument, typeGroup);

		// /////////////////////////////////////////////////////////////////////

		return this;
	}

	/**
	 * Saves the include declarations for a '<code>PrimitiveType</code>'
	 */
	@Override
	public void save() {
		if (selectedPType == null) {
			/* Log.debug("saveBody : selectedOperation is null"); */
		}
		else {
			CommandSupport.exec(selectedPType, "C++ primitive type save", new Runnable() {

				@Override
				public void run()
				{
					if (typeDocument.get().equals("")) {
						StereotypeUtil.unapply(selectedPType, Typedef.class);
					}
					else {
						Typedef cppType = StereotypeUtil.applyApp(selectedPType, Typedef.class);
						cppType.setDefinition(typeDocument.get());
					}
				}
			});
		}
	}


	/*
	 * (non-Javadoc)
	 *
	 * @see com.cea.accordcpp.core.ui.panels.AccordCppAbstractPanel#refreshPanel()
	 */
	@Override
	protected void refreshPanel() {
		if (selectedPType != null) {
			Typedef cppType = UMLUtil.getStereotypeApplication(selectedPType, Typedef.class);
			typeDocument.set(cppType != null ? cppType.getDefinition() : "");
		}
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see com.cea.accorduml.ui.views.panels.AccordUMLAbstractPanel#entryAction()
	 */
	@Override
	public void entryAction() {
		super.entryAction();
		reset();
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see com.cea.accordcpp.core.ui.panels.AccordCppAbstractPanel#checkModifications()
	 */
	@Override
	public boolean checkModifications() {
		Typedef cppType = UMLUtil.getStereotypeApplication(selectedPType, Typedef.class);
		String typeInModel = cppType != null ? cppType.getDefinition() : "";
		if (!typeDocument.get().equals(typeInModel)) {
			return true;
		}
		return false;
	}
}
