/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.modellibs.core.mappingrules;

import java.util.Iterator;
import org.eclipse.papyrus.designer.components.FCM.Port;
import org.eclipse.papyrus.designer.components.FCM.profile.IMappingRule;
import org.eclipse.papyrus.designer.components.FCM.profile.PortMapUtil;
import org.eclipse.papyrus.designer.transformation.base.utils.RealizationUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;

public class UseConjIntf
implements IMappingRule {
    private static final String CONJ_INTF_TYPE = "ConjIntfType_";
    private static final String CONJ_INTF = "ConjIntf_";

    public Type calcDerivedType(Port p, boolean update) {
        String name;
        Type type = p.getBase_Port().getType();
        if (!(type instanceof Interface)) {
            return null;
        }
        Interface typingInterface = (Interface)type;
        Interface derivedInterface = PortMapUtil.getDerivedInterface((Port)p, (String)CONJ_INTF, (boolean)update);
        Class derivedType = PortMapUtil.getDerivedClass((Port)p, (String)CONJ_INTF_TYPE, (boolean)update);
        if (!update) {
            return derivedType;
        }
        if (derivedInterface == null) {
            return null;
        }
        RealizationUtils.addUsage((Class)derivedType, (Interface)derivedInterface);
        for (Operation operation : typingInterface.getOwnedOperations()) {
            Type paramType;
            String paramName;
            name = operation.getName();
            Operation derivedOperation = derivedInterface.getOperation(name, null, null);
            if (derivedOperation == null) {
                derivedOperation = derivedInterface.createOwnedOperation(name, null, null);
            }
            derivedOperation.setIsAbstract(operation.isAbstract());
            derivedOperation.setIsStatic(operation.isStatic());
            derivedOperation.setIsUnique(operation.isUnique());
            derivedOperation.setIsQuery(operation.isQuery());
            for (Parameter parameter : operation.getOwnedParameters()) {
                paramName = parameter.getName();
                if (derivedOperation.getOwnedParameter(paramName, paramType = parameter.getType()) != null) continue;
                Parameter newParameter = derivedOperation.createOwnedParameter(parameter.getName(), parameter.getType());
                ParameterDirectionKind direction = parameter.getDirection();
                if (direction == ParameterDirectionKind.IN_LITERAL) {
                    newParameter.setDirection(ParameterDirectionKind.OUT_LITERAL);
                } else if (direction == ParameterDirectionKind.OUT_LITERAL) {
                    newParameter.setDirection(ParameterDirectionKind.IN_LITERAL);
                } else {
                    newParameter.setDirection(direction);
                }
                newParameter.setLower(parameter.getLower());
                newParameter.setUpper(parameter.getUpper());
            }
            Iterator derivedParameters = derivedOperation.getOwnedParameters().iterator();
            while (derivedParameters.hasNext()) {
                Parameter parameter = (Parameter)derivedParameters.next();
                paramName = parameter.getName();
                if (operation.getOwnedParameter(paramName, paramType = parameter.getType()) != null) continue;
                derivedParameters.remove();
            }
        }
        Iterator derivedOperations = derivedInterface.getOwnedOperations().iterator();
        while (derivedOperations.hasNext()) {
            Operation derivedOperation = (Operation)derivedOperations.next();
            name = derivedOperation.getName();
            if (typingInterface.getOperation(name, null, null) != null || !derivedInterface.getOperations().remove((Object)derivedOperation)) continue;
            derivedOperations = derivedInterface.getOwnedOperations().iterator();
        }
        return derivedType;
    }

    public boolean needsUpdate(Port p) {
        String name;
        Type type = p.getType();
        if (!(type instanceof Interface)) {
            return false;
        }
        Interface typingInterface = (Interface)type;
        Interface derivedInterface = PortMapUtil.getOrCreateDerivedInterface((Port)p, (String)CONJ_INTF);
        Class derivedType = PortMapUtil.getOrCreateDerivedClass((Port)p, (String)CONJ_INTF_TYPE);
        if (derivedInterface == null || derivedType == null) {
            return true;
        }
        for (Operation operation : typingInterface.getOwnedOperations()) {
            Type paramType;
            String paramName;
            name = operation.getName();
            Operation derivedOperation = derivedInterface.getOperation(name, null, null);
            if (derivedOperation == null) {
                return true;
            }
            derivedOperation.setIsAbstract(operation.isAbstract());
            derivedOperation.setIsStatic(operation.isStatic());
            derivedOperation.setIsUnique(operation.isUnique());
            derivedOperation.setIsQuery(operation.isQuery());
            for (Parameter parameter : operation.getOwnedParameters()) {
                paramName = parameter.getName();
                if (derivedOperation.getOwnedParameter(paramName, paramType = parameter.getType()) != null) continue;
                return true;
            }
            for (Parameter parameter : derivedOperation.getOwnedParameters()) {
                paramName = parameter.getName();
                if (operation.getOwnedParameter(paramName, paramType = parameter.getType()) != null) continue;
                return true;
            }
        }
        for (Operation derivedOperation : derivedInterface.getOwnedOperations()) {
            name = derivedOperation.getName();
            if (typingInterface.getOperation(name, null, null) != null) continue;
            return true;
        }
        return false;
    }
}

