/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.types.profile.UCMTypes.Types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PrimitiveCharKind implements Enumerator
{
    CHAR(0, "CHAR", "CHAR"),
    WCHAR(1, "WCHAR", "WCHAR");

    public static final int CHAR_VALUE = 0;
    public static final int WCHAR_VALUE = 1;
    private static final PrimitiveCharKind[] VALUES_ARRAY;
    public static final List<PrimitiveCharKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PrimitiveCharKind[]{CHAR, WCHAR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PrimitiveCharKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveCharKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveCharKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveCharKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveCharKind get(int value) {
        switch (value) {
            case 0: {
                return CHAR;
            }
            case 1: {
                return WCHAR;
            }
        }
        return null;
    }

    private PrimitiveCharKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

