/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.core.types.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.designer.ucm.core.Activator;
import org.eclipse.papyrus.designer.ucm.core.menu.EnhancedPopupMenu;
import org.eclipse.papyrus.designer.ucm.core.menu.MenuHelper;
import org.eclipse.papyrus.designer.ucm.core.provider.UCMContentProvider;
import org.eclipse.papyrus.designer.ucm.core.types.UCMElementTypesEnumerator;
import org.eclipse.papyrus.designer.ucm.core.utils.CreateUtils;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_components.ComponentModule;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_components.ComponentType;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.edit.utils.GMFCommandUtils;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class ComponentImplementationEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        GetEditContextRequest context;
        if (request instanceof GetEditContextRequest && (context = (GetEditContextRequest)request).getEditCommandRequest() instanceof CreateElementRequest) {
            return this.approveCreateElementRequest((CreateElementRequest)context.getEditCommandRequest());
        }
        return super.approveRequest(request);
    }

    protected boolean approveCreateElementRequest(CreateElementRequest request) {
        IElementType type = request.getElementType();
        EObject container = request.getContainer();
        return type != null && container instanceof Package && CreateUtils.nearestPackageWithStereo((Element)container, ComponentModule.class) != null;
    }

    protected ICommand getAfterCreateCommand(CreateElementRequest request) {
        return super.getAfterCreateCommand(request);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        CompositeCommand compositeCommand = new CompositeCommand("Component implementation configuration command");
        EObject newElement = request.getElementToConfigure();
        if (newElement == null) {
            return super.getAfterConfigureCommand(request);
        }
        IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)newElement);
        UCMContentProvider cp = new UCMContentProvider(PackageUtil.getRootPackage((Element)((Element)newElement)), UMLPackage.eINSTANCE.getClass_(), ComponentType.class);
        EnhancedPopupMenu popupMenu = MenuHelper.createPopupMenu(cp, "Choose component type", true);
        if (popupMenu.show((Control)Display.getCurrent().getActiveShell())) {
            Object result = popupMenu.getSubResult();
            if (result.equals("Create new type") && newElement instanceof Element) {
                CreateElementRequest createComponentType = new CreateElementRequest((EObject)((Element)newElement).getNearestPackage(), (IElementType)UCMElementTypesEnumerator.COMPONENT_TYPE, UMLPackage.eINSTANCE.getPackage_PackagedElement());
                ICommand createComponentTypeCmd = commandProvider.getEditCommand((IEditCommandRequest)createComponentType);
                try {
                    createComponentTypeCmd.execute(null, null);
                }
                catch (ExecutionException e) {
                    Activator.log.error((Throwable)e);
                }
                result = GMFCommandUtils.getCommandEObjectResult((ICommand)createComponentTypeCmd);
            }
            if (result instanceof Type) {
                Type componentType = (Type)result;
                CreateElementRequest createGeneralizationReq = new CreateElementRequest(newElement, (IElementType)UMLElementTypes.GENERALIZATION, UMLPackage.eINSTANCE.getClassifier_Generalization());
                ICommand createGeneralizationCmd = commandProvider.getEditCommand((IEditCommandRequest)createGeneralizationReq);
                compositeCommand.add((IUndoableOperation)createGeneralizationCmd);
                try {
                    createGeneralizationCmd.execute(null, null);
                }
                catch (ExecutionException e) {
                    Activator.log.error((Throwable)e);
                }
                newElement = GMFCommandUtils.getCommandEObjectResult((ICommand)createGeneralizationCmd);
                SetRequest setType = new SetRequest(createGeneralizationReq.getNewElement(), (EStructuralFeature)UMLPackage.eINSTANCE.getGeneralization_General(), (Object)componentType);
                compositeCommand.add((IUndoableOperation)commandProvider.getEditCommand((IEditCommandRequest)setType));
            }
        }
        return compositeCommand.isEmpty() ? super.getAfterConfigureCommand(request) : compositeCommand;
    }

    public void addToDiagram(EObject generalization) {
        try {
            EObject diagramEObj;
            ISashWindowsContainer windowsContainer = (ISashWindowsContainer)ServiceUtilsForEObject.getInstance().getServiceRegistry(generalization).getService(ISashWindowsContainer.class);
            Object model = windowsContainer.getActiveSashWindowsPage().getRawModel();
            if (model instanceof PageRef && (diagramEObj = ((PageRef)model).getEmfPageIdentifier()) instanceof Diagram) {
                Diagram diagram = (Diagram)diagramEObj;
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

