/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.library.transformations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.designer.deployment.tools.ConfigUtils;
import org.eclipse.papyrus.designer.deployment.tools.DepCreation;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.StUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoElem;
import org.eclipse.papyrus.designer.transformation.core.templates.TextTemplateBinding;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.ApplyTransformation;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.profile.standard.Destroy;

public class AddMethodInterceptors
implements IM2MTrafoElem {
    private static final String XTEND_CPP_UTILS_CPP_CALL = "!template CppUtils.cppCall";
    public final String origOpPrefix = "orig_";
    LazyCopier copier;
    Package tmCDP;
    Class tmClass;
    protected Class smClass;
    protected EList<Operation> operations;
    protected Map<Operation, Operation> interceptionOpMap;

    public AddMethodInterceptors(LazyCopier copier, Package tmCDP) {
        this.copier = copier;
        this.tmCDP = tmCDP;
        this.interceptionOpMap = new HashMap<Operation, Operation>();
    }

    protected Operation createInterceptionOperation(Operation operation) throws TransformationException {
        Operation copiedOperation = (Operation)EcoreUtil.copy((EObject)operation);
        this.tmClass.getOwnedOperations().add((Object)copiedOperation);
        StUtils.copyStereotypes((Element)operation, (Element)copiedOperation);
        copiedOperation.setName("orig_" + operation.getName());
        OpaqueBehavior b = (OpaqueBehavior)this.tmClass.createOwnedBehavior(operation.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
        String body = TextTemplateBinding.bind((String)XTEND_CPP_UTILS_CPP_CALL, (Element)copiedOperation);
        body = String.valueOf(body) + ";";
        b.getLanguages().add((Object)"C/C++");
        b.getBodies().add((Object)body);
        BasicEList methods = new BasicEList((Collection)operation.getMethods());
        for (Behavior behavior : methods) {
            copiedOperation.getMethods().add((Object)behavior);
        }
        b.setSpecification((BehavioralFeature)operation);
        return copiedOperation;
    }

    EList<Property> expandInterceptorExtension(Class mergeTemplateClass, Operation interceptionOperationInRule) throws TransformationException {
        for (Operation smOperation : this.operations) {
            Operation tmOperation = (Operation)this.copier.getCopy((Element)smOperation);
            String interceptionBody = AddMethodInterceptors.getBody(interceptionOperationInRule);
            if (StereotypeUtil.isApplied((Element)interceptionOperationInRule, Create.class) != StereotypeUtil.isApplied((Element)smOperation, Create.class) || StereotypeUtil.isApplied((Element)interceptionOperationInRule, Destroy.class) != StereotypeUtil.isApplied((Element)smOperation, Destroy.class)) continue;
            if (StereotypeUtil.isApplied((Element)interceptionOperationInRule, ApplyTransformation.class)) {
                TransformationContext.current.classifier = this.tmClass;
                interceptionBody = TextTemplateBinding.bind((String)interceptionBody, (Element)smOperation, null);
            }
            if (interceptionBody.length() <= 0) continue;
            interceptionBody = "// --- interception code from rule <" + mergeTemplateClass.getName() + "> ---\n" + interceptionBody;
            Operation interceptionOpInClass = this.interceptionOpMap.get(tmOperation);
            if (interceptionOpInClass == null) {
                Operation copiedOperation = this.createInterceptionOperation(tmOperation);
                if (StereotypeUtil.isApplied((Element)copiedOperation, Create.class)) {
                    StereotypeUtil.unapply((Element)copiedOperation, Create.class);
                }
                if (StereotypeUtil.isApplied((Element)copiedOperation, Destroy.class)) {
                    StereotypeUtil.unapply((Element)copiedOperation, Destroy.class);
                }
                interceptionOpInClass = tmOperation;
                this.interceptionOpMap.put(tmOperation, interceptionOpInClass);
            }
            String newBody = String.valueOf(interceptionBody) + "\n" + AddMethodInterceptors.getBody(interceptionOpInClass);
            AddMethodInterceptors.setBody(interceptionOpInClass, newBody);
        }
        return null;
    }

    public static String getBody(Operation op) {
        for (Behavior behavior : op.getMethods()) {
            EList bodies;
            if (!(behavior instanceof OpaqueBehavior) || (bodies = ((OpaqueBehavior)behavior).getBodies()).size() <= 0) continue;
            return (String)bodies.get(0);
        }
        return "";
    }

    public static void setBody(Operation op, String body) {
        for (Behavior behavior : op.getMethods()) {
            EList bodies;
            if (!(behavior instanceof OpaqueBehavior) || (bodies = ((OpaqueBehavior)behavior).getBodies()).size() <= 0) continue;
            bodies.set(0, (Object)body);
            break;
        }
    }

    public InstanceSpecification createContainerInstance(Class tmComponent, InstanceSpecification tmExecutorIS) throws TransformationException {
        InstanceSpecification containerIS = tmExecutorIS;
        for (Property extensionPart : tmComponent.getAttributes()) {
            Type tmContainerExtImpl = extensionPart.getType();
            if (!(tmContainerExtImpl instanceof Class) || DepUtils.getSlot((InstanceSpecification)tmExecutorIS, (Property)extensionPart) != null) continue;
            InstanceSpecification containerExtIS = DepCreation.createDepPlan((Package)this.tmCDP, (Class)((Class)tmContainerExtImpl), (String)(String.valueOf(containerIS.getName()) + "." + extensionPart.getName()), (boolean)false);
            ConfigUtils.configureInstance((InstanceSpecification)containerExtIS, (Property)extensionPart, null);
            DepCreation.createSlot((InstanceSpecification)containerIS, (InstanceSpecification)containerExtIS, (Property)extensionPart);
        }
        return containerIS;
    }

    public void transformElement(M2MTrafo trafo, Element element) throws TransformationException {
    }
}

