/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.base.utils;

import java.util.List;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.DeploymentPlan;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.StdModelLibs;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.ExecuteTrafoChain;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafoChain;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class TrafoUtils {
    public static final String TRAFOS_M2MTRANSFORMATIONS_SIMPLE = "trafos::m2mtransformations::Simple";
    public static final String TRAFOS_M2MTRANSFORMATIONS_STANDARD = "trafos::m2mtransformations::Standard";

    public static M2MTrafoChain getTransformationChain(Package cdp) {
        M2MTrafoChain chain = null;
        boolean isDeploymentPlan = false;
        if (cdp != null) {
            ExecuteTrafoChain execTrafoChain = (ExecuteTrafoChain)UMLUtil.getStereotypeApplication((Element)cdp, ExecuteTrafoChain.class);
            isDeploymentPlan = execTrafoChain instanceof DeploymentPlan;
            if (execTrafoChain != null) {
                chain = execTrafoChain.getChain();
            }
        }
        if (chain == null) {
            StdModelLibs.addResource(StdModelLibs.DESIGNER_TRAFOLIB_URI, (Element)cdp);
            NamedElement defaultChainNE = ElementUtils.getQualifiedElementFromRS((Element)cdp, (String)(isDeploymentPlan ? TRAFOS_M2MTRANSFORMATIONS_STANDARD : TRAFOS_M2MTRANSFORMATIONS_SIMPLE));
            if (defaultChainNE != null) {
                chain = (M2MTrafoChain)UMLUtil.getStereotypeApplication((Element)defaultChainNE, M2MTrafoChain.class);
            }
            if (chain == null) {
                throw new RuntimeException("Can not find default transformation chain");
            }
        }
        return chain;
    }

    public static List<M2MTrafo> getAdditionalTransformations(Package cdp) {
        ExecuteTrafoChain execTrafoChain;
        if (cdp != null && (execTrafoChain = (ExecuteTrafoChain)UMLUtil.getStereotypeApplication((Element)cdp, ExecuteTrafoChain.class)) != null) {
            return execTrafoChain.getAdditionalTrafos();
        }
        return null;
    }
}

