/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.extensionpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen2;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.Messages;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.PackageableElement;

public class LanguageCodegen {
    private static final String CLASS = "class";
    private static final String LANGUAGE = "language";
    private static final String ID = "id";
    public static final String ILANG_SUPPORT_ID = "org.eclipse.papyrus.designer.languages.common.extensionpoints.languageCodegen";
    static Map<ILangCodegen, String> generatorIDs = new HashMap<ILangCodegen, String>();
    static Map<ILangCodegen, String> generatorLanguages = new HashMap<ILangCodegen, String>();

    public static ILangCodegen getGenerator(String language) {
        return LanguageCodegen.getGenerator(language, null);
    }

    public static ILangCodegen getGenerator(String language, String id) {
        return LanguageCodegen.getGenerator(Pattern.compile(language.replace("+", "\\+")), id);
    }

    public static ILangCodegen getGenerator(Pattern languagePattern, String id) {
        List<ILangCodegen> generators = LanguageCodegen.getCodegenList(languagePattern);
        for (ILangCodegen generator : generators) {
            if (id != null && !generatorIDs.get(generator).equals(id)) continue;
            return generator;
        }
        throw new RuntimeException(String.format(Messages.LanguageSupport_LanguageNotSupported, languagePattern));
    }

    public static List<ILangCodegen> getEligibleGeneratorList(Pattern languagePattern, PackageableElement pe) {
        ArrayList<ILangCodegen> eligibleGenerators = new ArrayList<ILangCodegen>();
        for (ILangCodegen generator : LanguageCodegen.getCodegenList(languagePattern)) {
            if (generator instanceof ILangCodegen2) {
                if (!((ILangCodegen2)generator).isEligible((Element)pe)) continue;
                eligibleGenerators.add(generator);
                continue;
            }
            eligibleGenerators.add(generator);
        }
        return eligibleGenerators;
    }

    public static List<ILangCodegen> getCodegenList(Pattern languagePattern) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = reg.getConfigurationElementsFor(ILANG_SUPPORT_ID);
        ArrayList<ILangCodegen> generators = new ArrayList<ILangCodegen>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                Object obj;
                String id = configElement.getAttribute(ID);
                String extLanguage = configElement.getAttribute(LANGUAGE);
                Matcher m = languagePattern.matcher(extLanguage);
                if (m.matches() && (obj = configElement.createExecutableExtension(CLASS)) instanceof ILangCodegen) {
                    ILangCodegen generator = (ILangCodegen)obj;
                    if (!generatorIDs.containsKey(generator)) {
                        generatorIDs.put(generator, id);
                    }
                    if (!generatorLanguages.containsKey(generator)) {
                        generatorLanguages.put(generator, extLanguage);
                    }
                    generators.add((ILangCodegen)obj);
                }
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        return generators;
    }

    public static String getID(ILangCodegen generator) {
        return generatorIDs.get(generator);
    }

    public static String getLanguage(ILangCodegen generator) {
        return generatorLanguages.get(generator);
    }
}

