/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.hardware.actuator.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwDevice.impl.HWActuatorImpl;

import org.eclipse.papyrus.iotml.hardware.actuator.ActuatorPackage;
import org.eclipse.papyrus.iotml.hardware.actuator.EnergyKind;
import org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator;
import org.eclipse.papyrus.iotml.hardware.actuator.MovementKind;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Hw Common Actuator</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.actuator.impl.HwCommonActuatorImpl#getEnergyKind <em>Energy Kind</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.actuator.impl.HwCommonActuatorImpl#getMovementKind <em>Movement Kind</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.actuator.impl.HwCommonActuatorImpl#isPowered <em>Is Powered</em>}</li>
 * </ul>
 *
 * @generated
 */
public class HwCommonActuatorImpl extends HWActuatorImpl implements HwCommonActuator {
	/**
	 * The default value of the '{@link #getEnergyKind() <em>Energy Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnergyKind()
	 * @generated
	 * @ordered
	 */
	protected static final EnergyKind ENERGY_KIND_EDEFAULT = EnergyKind.ELECTRICAL;

	/**
	 * The cached value of the '{@link #getEnergyKind() <em>Energy Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnergyKind()
	 * @generated
	 * @ordered
	 */
	protected EnergyKind energyKind = ENERGY_KIND_EDEFAULT;

	/**
	 * The default value of the '{@link #getMovementKind() <em>Movement Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMovementKind()
	 * @generated
	 * @ordered
	 */
	protected static final MovementKind MOVEMENT_KIND_EDEFAULT = MovementKind.LINEAR;

	/**
	 * The cached value of the '{@link #getMovementKind() <em>Movement Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMovementKind()
	 * @generated
	 * @ordered
	 */
	protected MovementKind movementKind = MOVEMENT_KIND_EDEFAULT;

	/**
	 * The default value of the '{@link #isPowered() <em>Is Powered</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPowered()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_POWERED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isPowered() <em>Is Powered</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPowered()
	 * @generated
	 * @ordered
	 */
	protected boolean isPowered = IS_POWERED_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwCommonActuatorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ActuatorPackage.Literals.HW_COMMON_ACTUATOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EnergyKind getEnergyKind() {
		return energyKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnergyKind(EnergyKind newEnergyKind) {
		EnergyKind oldEnergyKind = energyKind;
		energyKind = newEnergyKind == null ? ENERGY_KIND_EDEFAULT : newEnergyKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ActuatorPackage.HW_COMMON_ACTUATOR__ENERGY_KIND, oldEnergyKind, energyKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MovementKind getMovementKind() {
		return movementKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMovementKind(MovementKind newMovementKind) {
		MovementKind oldMovementKind = movementKind;
		movementKind = newMovementKind == null ? MOVEMENT_KIND_EDEFAULT : newMovementKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ActuatorPackage.HW_COMMON_ACTUATOR__MOVEMENT_KIND, oldMovementKind, movementKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isPowered() {
		return isPowered;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsPowered(boolean newIsPowered) {
		boolean oldIsPowered = isPowered;
		isPowered = newIsPowered;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ActuatorPackage.HW_COMMON_ACTUATOR__IS_POWERED, oldIsPowered, isPowered));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ActuatorPackage.HW_COMMON_ACTUATOR__ENERGY_KIND:
				return getEnergyKind();
			case ActuatorPackage.HW_COMMON_ACTUATOR__MOVEMENT_KIND:
				return getMovementKind();
			case ActuatorPackage.HW_COMMON_ACTUATOR__IS_POWERED:
				return isPowered();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ActuatorPackage.HW_COMMON_ACTUATOR__ENERGY_KIND:
				setEnergyKind((EnergyKind)newValue);
				return;
			case ActuatorPackage.HW_COMMON_ACTUATOR__MOVEMENT_KIND:
				setMovementKind((MovementKind)newValue);
				return;
			case ActuatorPackage.HW_COMMON_ACTUATOR__IS_POWERED:
				setIsPowered((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ActuatorPackage.HW_COMMON_ACTUATOR__ENERGY_KIND:
				setEnergyKind(ENERGY_KIND_EDEFAULT);
				return;
			case ActuatorPackage.HW_COMMON_ACTUATOR__MOVEMENT_KIND:
				setMovementKind(MOVEMENT_KIND_EDEFAULT);
				return;
			case ActuatorPackage.HW_COMMON_ACTUATOR__IS_POWERED:
				setIsPowered(IS_POWERED_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ActuatorPackage.HW_COMMON_ACTUATOR__ENERGY_KIND:
				return energyKind != ENERGY_KIND_EDEFAULT;
			case ActuatorPackage.HW_COMMON_ACTUATOR__MOVEMENT_KIND:
				return movementKind != MOVEMENT_KIND_EDEFAULT;
			case ActuatorPackage.HW_COMMON_ACTUATOR__IS_POWERED:
				return isPowered != IS_POWERED_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (energyKind: ");
		result.append(energyKind);
		result.append(", movementKind: ");
		result.append(movementKind);
		result.append(", isPowered: ");
		result.append(isPowered);
		result.append(')');
		return result.toString();
	}

} //HwCommonActuatorImpl
