/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.hardware.core.util;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.EObjectValidator;

import org.eclipse.papyrus.iotml.hardware.core.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.iotml.hardware.core.CorePackage
 * @generated
 */
public class CoreValidator extends EObjectValidator {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final CoreValidator INSTANCE = new CoreValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "org.eclipse.papyrus.iotml.hardware.core";

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Allocate Resource C1' of 'Allocate Resource'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int ALLOCATE_RESOURCE__ALLOCATE_RESOURCE_C1 = 1;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Has Device C1' of 'Has Service'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int HAS_SERVICE__HAS_DEVICE_C1 = 2;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Has Device C2' of 'Has Service'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int HAS_SERVICE__HAS_DEVICE_C2 = 3;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 3;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CoreValidator() {
		super();
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage() {
	  return CorePackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
		switch (classifierID) {
			case CorePackage.ALLOCATE_RESOURCE:
				return validateAllocateResource((AllocateResource)value, diagnostics, context);
			case CorePackage.HAS_SERVICE:
				return validateHasService((HasService)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAllocateResource(AllocateResource allocateResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(allocateResource, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(allocateResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(allocateResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(allocateResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(allocateResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(allocateResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(allocateResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(allocateResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(allocateResource, diagnostics, context);
		if (result || diagnostics != null) result &= validateAllocateResource_AllocateResource_C1(allocateResource, diagnostics, context);
		return result;
	}

	/**
	 * Validates the AllocateResource_C1 constraint of '<em>Allocate Resource</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAllocateResource_AllocateResource_C1(AllocateResource allocateResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return allocateResource.AllocateResource_C1(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateHasService(HasService hasService, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(hasService, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(hasService, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(hasService, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(hasService, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(hasService, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(hasService, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(hasService, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(hasService, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(hasService, diagnostics, context);
		if (result || diagnostics != null) result &= validateHasService_HasDevice_C1(hasService, diagnostics, context);
		if (result || diagnostics != null) result &= validateHasService_HasDevice_C2(hasService, diagnostics, context);
		return result;
	}

	/**
	 * Validates the HasDevice_C1 constraint of '<em>Has Service</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateHasService_HasDevice_C1(HasService hasService, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return hasService.HasDevice_C1(diagnostics, context);
	}

	/**
	 * Validates the HasDevice_C2 constraint of '<em>Has Service</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateHasService_HasDevice_C2(HasService hasService, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return hasService.HasDevice_C2(diagnostics, context);
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //CoreValidator
