/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.hardware.sensor;

import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwDevice.HwI_O;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Hw Tag</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.sensor.HwTag#getTageFrequency <em>Tage Frequency</em>}</li>
 * </ul>
 *
 * @see org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage#getHwTag()
 * @model
 * @generated
 */
public interface HwTag extends HwI_O {
	/**
	 * Returns the value of the '<em><b>Tage Frequency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Tage Frequency</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Tage Frequency</em>' attribute.
	 * @see #setTageFrequency(double)
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage#getHwTag_TageFrequency()
	 * @model dataType="org.eclipse.uml2.types.Real" ordered="false"
	 * @generated
	 */
	double getTageFrequency();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.iotml.hardware.sensor.HwTag#getTageFrequency <em>Tage Frequency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Tage Frequency</em>' attribute.
	 * @see #getTageFrequency()
	 * @generated
	 */
	void setTageFrequency(double value);

} // HwTag
