/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.hardware.sensor.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwDevice.impl.HwI_OImpl;

import org.eclipse.papyrus.iotml.hardware.sensor.HwTag;
import org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Hw Tag</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.sensor.impl.HwTagImpl#getTageFrequency <em>Tage Frequency</em>}</li>
 * </ul>
 *
 * @generated
 */
public class HwTagImpl extends HwI_OImpl implements HwTag {
	/**
	 * The default value of the '{@link #getTageFrequency() <em>Tage Frequency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTageFrequency()
	 * @generated
	 * @ordered
	 */
	protected static final double TAGE_FREQUENCY_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTageFrequency() <em>Tage Frequency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTageFrequency()
	 * @generated
	 * @ordered
	 */
	protected double tageFrequency = TAGE_FREQUENCY_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwTagImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SensorPackage.Literals.HW_TAG;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getTageFrequency() {
		return tageFrequency;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTageFrequency(double newTageFrequency) {
		double oldTageFrequency = tageFrequency;
		tageFrequency = newTageFrequency;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SensorPackage.HW_TAG__TAGE_FREQUENCY, oldTageFrequency, tageFrequency));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SensorPackage.HW_TAG__TAGE_FREQUENCY:
				return getTageFrequency();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SensorPackage.HW_TAG__TAGE_FREQUENCY:
				setTageFrequency((Double)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SensorPackage.HW_TAG__TAGE_FREQUENCY:
				setTageFrequency(TAGE_FREQUENCY_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SensorPackage.HW_TAG__TAGE_FREQUENCY:
				return tageFrequency != TAGE_FREQUENCY_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (tageFrequency: ");
		result.append(tageFrequency);
		result.append(')');
		return result.toString();
	}

} //HwTagImpl
