/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.software.artefact;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.iotml.software.artefact.ArtefactFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/uml2/2.0.0/UML originalName='Artefact'"
 * @generated
 */
public interface ArtefactPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "artefact";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/papyrus/iotml/0.7/IoTML/Software/Artefact";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Artefact";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ArtefactPackage eINSTANCE = org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.software.artefact.impl.PropertyAccessImpl <em>Property Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.software.artefact.impl.PropertyAccessImpl
	 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl#getPropertyAccess()
	 * @generated
	 */
	int PROPERTY_ACCESS = 0;

	/**
	 * The feature id for the '<em><b>Base Association</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__BASE_ASSOCIATION = 0;

	/**
	 * The feature id for the '<em><b>Accessed Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS__ACCESSED_PROPERTY = 1;

	/**
	 * The number of structural features of the '<em>Property Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_ACCESS_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.software.artefact.impl.DigitalArtefactImpl <em>Digital Artefact</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.software.artefact.impl.DigitalArtefactImpl
	 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl#getDigitalArtefact()
	 * @generated
	 */
	int DIGITAL_ARTEFACT = 1;

	/**
	 * The feature id for the '<em><b>Base Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIGITAL_ARTEFACT__BASE_CLASS = 0;

	/**
	 * The number of structural features of the '<em>Digital Artefact</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIGITAL_ARTEFACT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.software.artefact.impl.VirtualEntityImpl <em>Virtual Entity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.software.artefact.impl.VirtualEntityImpl
	 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl#getVirtualEntity()
	 * @generated
	 */
	int VIRTUAL_ENTITY = 2;

	/**
	 * The feature id for the '<em><b>Base Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VIRTUAL_ENTITY__BASE_CLASS = DIGITAL_ARTEFACT__BASE_CLASS;

	/**
	 * The feature id for the '<em><b>Phisical Entity Specification</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VIRTUAL_ENTITY__PHISICAL_ENTITY_SPECIFICATION = DIGITAL_ARTEFACT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Physical Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VIRTUAL_ENTITY__PHYSICAL_ENTITY = DIGITAL_ARTEFACT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Virtual Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VIRTUAL_ENTITY_FEATURE_COUNT = DIGITAL_ARTEFACT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.software.artefact.impl.ProvideServiceImpl <em>Provide Service</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ProvideServiceImpl
	 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl#getProvideService()
	 * @generated
	 */
	int PROVIDE_SERVICE = 3;

	/**
	 * The feature id for the '<em><b>Base Association</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROVIDE_SERVICE__BASE_ASSOCIATION = 0;

	/**
	 * The number of structural features of the '<em>Provide Service</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROVIDE_SERVICE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.software.artefact.impl.ProvideResourceImpl <em>Provide Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ProvideResourceImpl
	 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl#getProvideResource()
	 * @generated
	 */
	int PROVIDE_RESOURCE = 4;

	/**
	 * The feature id for the '<em><b>Base Association</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROVIDE_RESOURCE__BASE_ASSOCIATION = 0;

	/**
	 * The number of structural features of the '<em>Provide Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROVIDE_RESOURCE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.software.artefact.impl.ServiceDescriptionImpl <em>Service Description</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ServiceDescriptionImpl
	 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl#getServiceDescription()
	 * @generated
	 */
	int SERVICE_DESCRIPTION = 5;

	/**
	 * The feature id for the '<em><b>Base Interface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_DESCRIPTION__BASE_INTERFACE = 0;

	/**
	 * The feature id for the '<em><b>Resource Get Set</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_DESCRIPTION__RESOURCE_GET_SET = 1;

	/**
	 * The number of structural features of the '<em>Service Description</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_DESCRIPTION_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.software.artefact.impl.ServiceImpl <em>Service</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ServiceImpl
	 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl#getService()
	 * @generated
	 */
	int SERVICE = 6;

	/**
	 * The feature id for the '<em><b>Base Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE__BASE_CLASS = DIGITAL_ARTEFACT__BASE_CLASS;

	/**
	 * The number of structural features of the '<em>Service</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_FEATURE_COUNT = DIGITAL_ARTEFACT_FEATURE_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.software.artefact.PropertyAccess <em>Property Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Property Access</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.PropertyAccess
	 * @generated
	 */
	EClass getPropertyAccess();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.artefact.PropertyAccess#getBase_Association <em>Base Association</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Base Association</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.PropertyAccess#getBase_Association()
	 * @see #getPropertyAccess()
	 * @generated
	 */
	EReference getPropertyAccess_Base_Association();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.artefact.PropertyAccess#getAccessedProperty <em>Accessed Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Accessed Property</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.PropertyAccess#getAccessedProperty()
	 * @see #getPropertyAccess()
	 * @generated
	 */
	EReference getPropertyAccess_AccessedProperty();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.software.artefact.DigitalArtefact <em>Digital Artefact</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Digital Artefact</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.DigitalArtefact
	 * @generated
	 */
	EClass getDigitalArtefact();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.artefact.DigitalArtefact#getBase_Class <em>Base Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Base Class</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.DigitalArtefact#getBase_Class()
	 * @see #getDigitalArtefact()
	 * @generated
	 */
	EReference getDigitalArtefact_Base_Class();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.software.artefact.VirtualEntity <em>Virtual Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Virtual Entity</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.VirtualEntity
	 * @generated
	 */
	EClass getVirtualEntity();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.artefact.VirtualEntity#getPhisicalEntitySpecification <em>Phisical Entity Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Phisical Entity Specification</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.VirtualEntity#getPhisicalEntitySpecification()
	 * @see #getVirtualEntity()
	 * @generated
	 */
	EReference getVirtualEntity_PhisicalEntitySpecification();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.artefact.VirtualEntity#getPhysicalEntity <em>Physical Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Physical Entity</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.VirtualEntity#getPhysicalEntity()
	 * @see #getVirtualEntity()
	 * @generated
	 */
	EReference getVirtualEntity_PhysicalEntity();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.software.artefact.ProvideService <em>Provide Service</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Provide Service</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.ProvideService
	 * @generated
	 */
	EClass getProvideService();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.artefact.ProvideService#getBase_Association <em>Base Association</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Base Association</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.ProvideService#getBase_Association()
	 * @see #getProvideService()
	 * @generated
	 */
	EReference getProvideService_Base_Association();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.software.artefact.ProvideResource <em>Provide Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Provide Resource</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.ProvideResource
	 * @generated
	 */
	EClass getProvideResource();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.artefact.ProvideResource#getBase_Association <em>Base Association</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Base Association</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.ProvideResource#getBase_Association()
	 * @see #getProvideResource()
	 * @generated
	 */
	EReference getProvideResource_Base_Association();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.software.artefact.ServiceDescription <em>Service Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Service Description</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.ServiceDescription
	 * @generated
	 */
	EClass getServiceDescription();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.artefact.ServiceDescription#getBase_Interface <em>Base Interface</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Base Interface</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.ServiceDescription#getBase_Interface()
	 * @see #getServiceDescription()
	 * @generated
	 */
	EReference getServiceDescription_Base_Interface();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.papyrus.iotml.software.artefact.ServiceDescription#getResourceGetSet <em>Resource Get Set</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Resource Get Set</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.ServiceDescription#getResourceGetSet()
	 * @see #getServiceDescription()
	 * @generated
	 */
	EReference getServiceDescription_ResourceGetSet();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.software.artefact.Service <em>Service</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Service</em>'.
	 * @see org.eclipse.papyrus.iotml.software.artefact.Service
	 * @generated
	 */
	EClass getService();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ArtefactFactory getArtefactFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.software.artefact.impl.PropertyAccessImpl <em>Property Access</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.software.artefact.impl.PropertyAccessImpl
		 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl#getPropertyAccess()
		 * @generated
		 */
		EClass PROPERTY_ACCESS = eINSTANCE.getPropertyAccess();

		/**
		 * The meta object literal for the '<em><b>Base Association</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROPERTY_ACCESS__BASE_ASSOCIATION = eINSTANCE.getPropertyAccess_Base_Association();

		/**
		 * The meta object literal for the '<em><b>Accessed Property</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROPERTY_ACCESS__ACCESSED_PROPERTY = eINSTANCE.getPropertyAccess_AccessedProperty();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.software.artefact.impl.DigitalArtefactImpl <em>Digital Artefact</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.software.artefact.impl.DigitalArtefactImpl
		 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl#getDigitalArtefact()
		 * @generated
		 */
		EClass DIGITAL_ARTEFACT = eINSTANCE.getDigitalArtefact();

		/**
		 * The meta object literal for the '<em><b>Base Class</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DIGITAL_ARTEFACT__BASE_CLASS = eINSTANCE.getDigitalArtefact_Base_Class();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.software.artefact.impl.VirtualEntityImpl <em>Virtual Entity</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.software.artefact.impl.VirtualEntityImpl
		 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl#getVirtualEntity()
		 * @generated
		 */
		EClass VIRTUAL_ENTITY = eINSTANCE.getVirtualEntity();

		/**
		 * The meta object literal for the '<em><b>Phisical Entity Specification</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VIRTUAL_ENTITY__PHISICAL_ENTITY_SPECIFICATION = eINSTANCE.getVirtualEntity_PhisicalEntitySpecification();

		/**
		 * The meta object literal for the '<em><b>Physical Entity</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VIRTUAL_ENTITY__PHYSICAL_ENTITY = eINSTANCE.getVirtualEntity_PhysicalEntity();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.software.artefact.impl.ProvideServiceImpl <em>Provide Service</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ProvideServiceImpl
		 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl#getProvideService()
		 * @generated
		 */
		EClass PROVIDE_SERVICE = eINSTANCE.getProvideService();

		/**
		 * The meta object literal for the '<em><b>Base Association</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROVIDE_SERVICE__BASE_ASSOCIATION = eINSTANCE.getProvideService_Base_Association();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.software.artefact.impl.ProvideResourceImpl <em>Provide Resource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ProvideResourceImpl
		 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl#getProvideResource()
		 * @generated
		 */
		EClass PROVIDE_RESOURCE = eINSTANCE.getProvideResource();

		/**
		 * The meta object literal for the '<em><b>Base Association</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROVIDE_RESOURCE__BASE_ASSOCIATION = eINSTANCE.getProvideResource_Base_Association();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.software.artefact.impl.ServiceDescriptionImpl <em>Service Description</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ServiceDescriptionImpl
		 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl#getServiceDescription()
		 * @generated
		 */
		EClass SERVICE_DESCRIPTION = eINSTANCE.getServiceDescription();

		/**
		 * The meta object literal for the '<em><b>Base Interface</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_DESCRIPTION__BASE_INTERFACE = eINSTANCE.getServiceDescription_Base_Interface();

		/**
		 * The meta object literal for the '<em><b>Resource Get Set</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_DESCRIPTION__RESOURCE_GET_SET = eINSTANCE.getServiceDescription_ResourceGetSet();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.software.artefact.impl.ServiceImpl <em>Service</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ServiceImpl
		 * @see org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl#getService()
		 * @generated
		 */
		EClass SERVICE = eINSTANCE.getService();

	}

} //ArtefactPackage
