/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.software.core.structure.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.papyrus.MARTE.MARTEPackage;

import org.eclipse.papyrus.MARTE_Library.BasicNFP_Types.BasicNFP_TypesPackage;

import org.eclipse.papyrus.MARTE_Library.GRM_BasicTypes.GRM_BasicTypesPackage;

import org.eclipse.papyrus.MARTE_Library.MARTE_DataTypes.MARTE_DataTypesPackage;

import org.eclipse.papyrus.MARTE_Library.MARTE_PrimitivesTypes.MARTE_PrimitivesTypesPackage;

import org.eclipse.papyrus.MARTE_Library.MeasurementUnits.MeasurementUnitsPackage;

import org.eclipse.papyrus.MARTE_Library.RS_Library.RS_LibraryPackage;

import org.eclipse.papyrus.MARTE_Library.TimeLibrary.TimeLibraryPackage;

import org.eclipse.papyrus.MARTE_Library.TimeTypesLibrary.TimeTypesLibraryPackage;

import org.eclipse.papyrus.iotml.IoTMLPackage;

import org.eclipse.papyrus.iotml.animate.AnimatePackage;

import org.eclipse.papyrus.iotml.animate.impl.AnimatePackageImpl;

import org.eclipse.papyrus.iotml.hardware.HardwarePackage;

import org.eclipse.papyrus.iotml.hardware.actuator.ActuatorPackage;

import org.eclipse.papyrus.iotml.hardware.actuator.impl.ActuatorPackageImpl;

import org.eclipse.papyrus.iotml.hardware.core.CorePackage;

import org.eclipse.papyrus.iotml.hardware.core.impl.CorePackageImpl;

import org.eclipse.papyrus.iotml.hardware.impl.HardwarePackageImpl;

import org.eclipse.papyrus.iotml.hardware.network.NetworkPackage;

import org.eclipse.papyrus.iotml.hardware.network.impl.NetworkPackageImpl;

import org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage;

import org.eclipse.papyrus.iotml.hardware.sensor.impl.SensorPackageImpl;

import org.eclipse.papyrus.iotml.hybrid.HybridPackage;

import org.eclipse.papyrus.iotml.hybrid.impl.HybridPackageImpl;

import org.eclipse.papyrus.iotml.impl.IoTMLPackageImpl;

import org.eclipse.papyrus.iotml.software.SoftwarePackage;
import org.eclipse.papyrus.iotml.software.artefact.ArtefactPackage;

import org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl;

import org.eclipse.papyrus.iotml.software.core.structure.DetailedValueSpecification;
import org.eclipse.papyrus.iotml.software.core.structure.MetaValueSpecification;
import org.eclipse.papyrus.iotml.software.core.structure.StructureFactory;
import org.eclipse.papyrus.iotml.software.core.structure.StructurePackage;

import org.eclipse.papyrus.iotml.software.impl.SoftwarePackageImpl;
import org.eclipse.papyrus.iotml.software.resource.ResourcePackage;

import org.eclipse.papyrus.iotml.software.resource.impl.ResourcePackageImpl;

import org.eclipse.papyrus.sysml14.sysmlPackage;

import org.eclipse.uml2.types.TypesPackage;

import org.eclipse.uml2.uml.UMLPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class StructurePackageImpl extends EPackageImpl implements StructurePackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass metaValueSpecificationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass detailedValueSpecificationEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.papyrus.iotml.software.core.structure.StructurePackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private StructurePackageImpl() {
		super(eNS_URI, StructureFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link StructurePackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static StructurePackage init() {
		if (isInited) return (StructurePackage)EPackage.Registry.INSTANCE.getEPackage(StructurePackage.eNS_URI);

		// Obtain or create and register package
		StructurePackageImpl theStructurePackage = (StructurePackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof StructurePackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new StructurePackageImpl());

		isInited = true;

		// Initialize simple dependencies
		EcorePackage.eINSTANCE.eClass();
		MARTEPackage.eINSTANCE.eClass();
		MARTE_PrimitivesTypesPackage.eINSTANCE.eClass();
		MeasurementUnitsPackage.eINSTANCE.eClass();
		GRM_BasicTypesPackage.eINSTANCE.eClass();
		BasicNFP_TypesPackage.eINSTANCE.eClass();
		MARTE_DataTypesPackage.eINSTANCE.eClass();
		TimeTypesLibraryPackage.eINSTANCE.eClass();
		TimeLibraryPackage.eINSTANCE.eClass();
		RS_LibraryPackage.eINSTANCE.eClass();
		sysmlPackage.eINSTANCE.eClass();
		TypesPackage.eINSTANCE.eClass();
		UMLPackage.eINSTANCE.eClass();

		// Obtain or create and register interdependencies
		IoTMLPackageImpl theIoTMLPackage = (IoTMLPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(IoTMLPackage.eNS_URI) instanceof IoTMLPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(IoTMLPackage.eNS_URI) : IoTMLPackage.eINSTANCE);
		AnimatePackageImpl theAnimatePackage = (AnimatePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(AnimatePackage.eNS_URI) instanceof AnimatePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(AnimatePackage.eNS_URI) : AnimatePackage.eINSTANCE);
		HardwarePackageImpl theHardwarePackage = (HardwarePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(HardwarePackage.eNS_URI) instanceof HardwarePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(HardwarePackage.eNS_URI) : HardwarePackage.eINSTANCE);
		ActuatorPackageImpl theActuatorPackage = (ActuatorPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ActuatorPackage.eNS_URI) instanceof ActuatorPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ActuatorPackage.eNS_URI) : ActuatorPackage.eINSTANCE);
		SensorPackageImpl theSensorPackage = (SensorPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(SensorPackage.eNS_URI) instanceof SensorPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(SensorPackage.eNS_URI) : SensorPackage.eINSTANCE);
		NetworkPackageImpl theNetworkPackage = (NetworkPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(NetworkPackage.eNS_URI) instanceof NetworkPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(NetworkPackage.eNS_URI) : NetworkPackage.eINSTANCE);
		CorePackageImpl theCorePackage = (CorePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI) instanceof CorePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI) : CorePackage.eINSTANCE);
		HybridPackageImpl theHybridPackage = (HybridPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(HybridPackage.eNS_URI) instanceof HybridPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(HybridPackage.eNS_URI) : HybridPackage.eINSTANCE);
		SoftwarePackageImpl theSoftwarePackage = (SoftwarePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(SoftwarePackage.eNS_URI) instanceof SoftwarePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(SoftwarePackage.eNS_URI) : SoftwarePackage.eINSTANCE);
		ArtefactPackageImpl theArtefactPackage = (ArtefactPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ArtefactPackage.eNS_URI) instanceof ArtefactPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ArtefactPackage.eNS_URI) : ArtefactPackage.eINSTANCE);
		org.eclipse.papyrus.iotml.software.core.impl.CorePackageImpl theCorePackage_1 = (org.eclipse.papyrus.iotml.software.core.impl.CorePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(org.eclipse.papyrus.iotml.software.core.CorePackage.eNS_URI) instanceof org.eclipse.papyrus.iotml.software.core.impl.CorePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(org.eclipse.papyrus.iotml.software.core.CorePackage.eNS_URI) : org.eclipse.papyrus.iotml.software.core.CorePackage.eINSTANCE);
		ResourcePackageImpl theResourcePackage = (ResourcePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ResourcePackage.eNS_URI) instanceof ResourcePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ResourcePackage.eNS_URI) : ResourcePackage.eINSTANCE);

		// Create package meta-data objects
		theStructurePackage.createPackageContents();
		theIoTMLPackage.createPackageContents();
		theAnimatePackage.createPackageContents();
		theHardwarePackage.createPackageContents();
		theActuatorPackage.createPackageContents();
		theSensorPackage.createPackageContents();
		theNetworkPackage.createPackageContents();
		theCorePackage.createPackageContents();
		theHybridPackage.createPackageContents();
		theSoftwarePackage.createPackageContents();
		theArtefactPackage.createPackageContents();
		theCorePackage_1.createPackageContents();
		theResourcePackage.createPackageContents();

		// Initialize created meta-data
		theStructurePackage.initializePackageContents();
		theIoTMLPackage.initializePackageContents();
		theAnimatePackage.initializePackageContents();
		theHardwarePackage.initializePackageContents();
		theActuatorPackage.initializePackageContents();
		theSensorPackage.initializePackageContents();
		theNetworkPackage.initializePackageContents();
		theCorePackage.initializePackageContents();
		theHybridPackage.initializePackageContents();
		theSoftwarePackage.initializePackageContents();
		theArtefactPackage.initializePackageContents();
		theCorePackage_1.initializePackageContents();
		theResourcePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theStructurePackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(StructurePackage.eNS_URI, theStructurePackage);
		return theStructurePackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMetaValueSpecification() {
		return metaValueSpecificationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMetaValueSpecification_Base_ValueSpecification() {
		return (EReference)metaValueSpecificationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMetaValueSpecification_Type() {
		return (EReference)metaValueSpecificationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMetaValueSpecification_Description() {
		return (EAttribute)metaValueSpecificationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDetailedValueSpecification() {
		return detailedValueSpecificationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDetailedValueSpecification_Base_ValueSpecification() {
		return (EReference)detailedValueSpecificationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDetailedValueSpecification_MetaSpecification() {
		return (EReference)detailedValueSpecificationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StructureFactory getStructureFactory() {
		return (StructureFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		metaValueSpecificationEClass = createEClass(META_VALUE_SPECIFICATION);
		createEReference(metaValueSpecificationEClass, META_VALUE_SPECIFICATION__BASE_VALUE_SPECIFICATION);
		createEReference(metaValueSpecificationEClass, META_VALUE_SPECIFICATION__TYPE);
		createEAttribute(metaValueSpecificationEClass, META_VALUE_SPECIFICATION__DESCRIPTION);

		detailedValueSpecificationEClass = createEClass(DETAILED_VALUE_SPECIFICATION);
		createEReference(detailedValueSpecificationEClass, DETAILED_VALUE_SPECIFICATION__BASE_VALUE_SPECIFICATION);
		createEReference(detailedValueSpecificationEClass, DETAILED_VALUE_SPECIFICATION__META_SPECIFICATION);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		UMLPackage theUMLPackage = (UMLPackage)EPackage.Registry.INSTANCE.getEPackage(UMLPackage.eNS_URI);
		TypesPackage theTypesPackage = (TypesPackage)EPackage.Registry.INSTANCE.getEPackage(TypesPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes

		// Initialize classes and features; add operations and parameters
		initEClass(metaValueSpecificationEClass, MetaValueSpecification.class, "MetaValueSpecification", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMetaValueSpecification_Base_ValueSpecification(), theUMLPackage.getValueSpecification(), null, "base_ValueSpecification", null, 1, 1, MetaValueSpecification.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getMetaValueSpecification_Type(), theUMLPackage.getType(), null, "type", null, 0, 1, MetaValueSpecification.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, !IS_ORDERED);
		initEAttribute(getMetaValueSpecification_Description(), theTypesPackage.getString(), "description", null, 0, 1, MetaValueSpecification.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(detailedValueSpecificationEClass, DetailedValueSpecification.class, "DetailedValueSpecification", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getDetailedValueSpecification_Base_ValueSpecification(), theUMLPackage.getValueSpecification(), null, "base_ValueSpecification", null, 1, 1, DetailedValueSpecification.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getDetailedValueSpecification_MetaSpecification(), this.getMetaValueSpecification(), null, "metaSpecification", null, 0, -1, DetailedValueSpecification.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		// Create annotations
		// http://www.eclipse.org/uml2/2.0.0/UML
		createUMLAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/uml2/2.0.0/UML</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createUMLAnnotations() {
		String source = "http://www.eclipse.org/uml2/2.0.0/UML";	
		addAnnotation
		  (this, 
		   source, 
		   new String[] {
			 "originalName", "Structure"
		   });
	}

} //StructurePackageImpl
