/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.common;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.requirements.sysml14.preferences.Activator;
import org.eclipse.papyrus.sysml14.requirements.Requirement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class Utils {
    private Utils() {
    }

    public static boolean isRequirementStereotype(Stereotype stereotype) {
        if ("SysML::Requirements::Requirement".equals(stereotype.getQualifiedName())) {
            return true;
        }
        for (Class superStereotype : stereotype.getSuperClasses()) {
            if (!(superStereotype instanceof Stereotype) || !Utils.isRequirementStereotype((Stereotype)superStereotype)) continue;
            return true;
        }
        return false;
    }

    public static Package getToPackage(Element elememt) {
        Package tmp = elememt.getNearestPackage();
        while (tmp.getOwner() != null && tmp.getOwner() instanceof Package) {
            tmp = (Package)tmp.getOwner();
        }
        return tmp;
    }

    public static ArrayList<Profile> getMissingRequiredProfileApplications(Package element, ArrayList<Profile> requiredProfiles) {
        ArrayList<Profile> missingProfiles = new ArrayList<Profile>();
        for (Profile profile : requiredProfiles) {
            if (element.isProfileApplied(profile)) continue;
            missingProfiles.add(profile);
        }
        return missingProfiles;
    }

    public static void applyMissingProfiles(Package thePackage, ArrayList<Profile> missingProfiles) {
        for (Profile missingProfile : Utils.getMissingRequiredProfileApplications(thePackage, missingProfiles)) {
            thePackage.applyProfile(missingProfile);
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Applying missing profile", (String)("The profile " + missingProfile.getQualifiedName() + " was applied to " + thePackage.getName()));
        }
    }

    public static String getNewRequirementID(Element parent) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String prefix = store.getString("REQUIREMENT_ID_PREFIX");
        String separator = store.getString("CHILD_REQUIREMENTS_SEPARATOR");
        boolean idUniqueInModel = store.getBoolean("REQUIREMENT_ID_UNIQUE_IN_ENTIRE_MODEL");
        String parentRequirementId = "";
        String parentRequirementIdSuffix = "";
        if (parent instanceof Class) {
            if (UMLUtil.getStereotypeApplication((Element)((Class)parent), Requirement.class) != null) {
                parentRequirementId = (String)UMLUtil.getTaggedValue((Element)((Class)parent), (String)"SysML::Requirements::Requirement", (String)"id");
                parentRequirementIdSuffix = parentRequirementId.replaceAll(prefix, "");
            }
        } else {
            separator = "";
        }
        int digit = store.getInt("REQUIREMENT_ID_DIGIT");
        int i = 0;
        DecimalFormat df = new DecimalFormat();
        df.setMinimumIntegerDigits(digit);
        String value = df.format(i);
        boolean IDexist = true;
        while (IDexist) {
            IDexist = false;
            value = df.format(++i);
            EList elements = null;
            elements = idUniqueInModel ? parent.getModel().allOwnedElements() : parent.allOwnedElements();
            Iterator iterator = elements.iterator();
            while (iterator.hasNext() && !IDexist) {
                Element element = (Element)iterator.next();
                EObject applyStereotype = UMLUtil.getStereotypeApplication((Element)element, Requirement.class);
                if (!(applyStereotype instanceof Requirement)) continue;
                String existedID = ((Requirement)applyStereotype).getId();
                String newID = String.valueOf(prefix) + parentRequirementIdSuffix + separator + value;
                if (!newID.equals(existedID)) continue;
                IDexist = true;
            }
        }
        return String.valueOf(prefix) + parentRequirementIdSuffix + separator + value;
    }
}

