/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.bt.types.utils;

import java.util.List;
import org.eclipse.papyrus.robotics.bt.profile.bt.OutFlowPort;
import org.eclipse.papyrus.robotics.bt.types.utils.uml.AbstractActionPinUpdater;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.ValueSpecificationAction;

public class BtParameterPinUpdater
extends AbstractActionPinUpdater<ValueSpecificationAction> {
    @Override
    public void updatePins(ValueSpecificationAction node) {
        if (node != null) {
            ValueSpecification valueSpecification;
            OutputPin result = node.getResult();
            if (result == null) {
                result = UMLFactory.eINSTANCE.createOutputPin();
                result.setLower(1);
                result.setUpper(1);
                result.setName("p");
            }
            if ((valueSpecification = node.getValue()) != null) {
                InstanceSpecification specification;
                if (valueSpecification instanceof LiteralInteger) {
                    result.setType((Type)this.getUMLPrimitiveType("Integer", valueSpecification.getModel()));
                } else if (valueSpecification instanceof LiteralUnlimitedNatural) {
                    result.setType((Type)this.getUMLPrimitiveType("UnlimitedNatural", valueSpecification.getModel()));
                } else if (valueSpecification instanceof LiteralReal) {
                    result.setType((Type)this.getUMLPrimitiveType("Real", valueSpecification.getModel()));
                } else if (valueSpecification instanceof LiteralString) {
                    result.setType((Type)this.getUMLPrimitiveType("String", valueSpecification.getModel()));
                } else if (valueSpecification instanceof LiteralBoolean) {
                    result.setType((Type)this.getUMLPrimitiveType("Boolean", valueSpecification.getModel()));
                } else if (valueSpecification instanceof InstanceValue && (specification = ((InstanceValue)valueSpecification).getInstance()) != null) {
                    if (specification instanceof EnumerationLiteral) {
                        result.setType((Type)((EnumerationLiteral)specification).getEnumeration());
                    } else if (specification.getClassifiers().size() == 1) {
                        result.setType((Type)specification.getClassifiers().iterator().next());
                    } else if (specification.getClassifiers().size() > 1) {
                        result.setType((Type)BtParameterPinUpdater.getFirstCommonSuperClassifier((List<Classifier>)specification.getClassifiers()));
                    }
                }
            }
            node.setResult(result);
            StereotypeUtil.apply((Element)result, OutFlowPort.class);
        }
    }
}

