/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.utils;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.robotics.bpc.profile.bpc.BPCPackage;
import org.eclipse.papyrus.robotics.bpc.profile.bpc.Entity;
import org.eclipse.papyrus.robotics.ros2.preferences.Ros2PreferenceUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PackageXMLUtils {
    public static String description(List<Package> modelList) {
        String description = PackageXMLUtils.getField(modelList, BPCPackage.eINSTANCE.getEntity_Description());
        if (description != null) {
            return description;
        }
        return "No description";
    }

    public static String description(Package model) {
        return PackageXMLUtils.description(Collections.singletonList(model));
    }

    public static String getAuthorName(List<Package> modelList) {
        String author = PackageXMLUtils.getField(modelList, BPCPackage.eINSTANCE.getEntity_Authorship());
        if (author != null) {
            int idx = author.indexOf(" ");
            if (idx > 0) {
                return author.substring(idx + 1);
            }
            return author;
        }
        return Ros2PreferenceUtils.getAuthorName();
    }

    public static String getAuthorName(Package model) {
        return PackageXMLUtils.getAuthorMail(Collections.singletonList(model));
    }

    public static String getAuthorMail(List<Package> modelList) {
        String author = PackageXMLUtils.getField(modelList, BPCPackage.eINSTANCE.getEntity_Authorship());
        if (author != null) {
            int idx = author.indexOf(" ");
            if (idx > 0) {
                return author.substring(0, idx);
            }
            return author;
        }
        return Ros2PreferenceUtils.getAuthorMail();
    }

    public static String getAuthorMail(Package model) {
        return PackageXMLUtils.getAuthorMail(Collections.singletonList(model));
    }

    public static String getMaintainerName(List<Package> modelList) {
        String maintainer = PackageXMLUtils.getField(modelList, BPCPackage.eINSTANCE.getEntity_Provenance());
        if (maintainer != null) {
            int idx = maintainer.indexOf(" ");
            if (idx > 0) {
                return maintainer.substring(idx + 1);
            }
            return maintainer;
        }
        return Ros2PreferenceUtils.getMaintainerName();
    }

    public static String getMaintainerName(Package model) {
        return PackageXMLUtils.getMaintainerName(Collections.singletonList(model));
    }

    public static String getMaintainerMail(List<Package> modelList) {
        String maintainer = PackageXMLUtils.getField(modelList, BPCPackage.eINSTANCE.getEntity_Provenance());
        if (maintainer != null) {
            int idx = maintainer.indexOf(" ");
            if (idx > 0) {
                return maintainer.substring(0, idx);
            }
            return maintainer;
        }
        return Ros2PreferenceUtils.getMaintainerMail();
    }

    public static String getMaintainerMail(Package model) {
        return PackageXMLUtils.getMaintainerMail(Collections.singletonList(model));
    }

    public static String getField(List<Package> modelList, EAttribute feature) {
        for (Package pkg : modelList) {
            Entity application = (Entity)UMLUtil.getStereotypeApplication((Element)pkg, Entity.class);
            if (application == null || !(application.eGet((EStructuralFeature)feature) instanceof String)) continue;
            Object _eGet = application.eGet((EStructuralFeature)feature);
            return (String)_eGet;
        }
        return null;
    }
}

