/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.bt.xsdgw.uml2xml.lib;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Stack;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.robotics.bt.profile.bt.TreeRoot;
import org.eclipse.papyrus.robotics.bt.xsdgw.uml2xml.executors.BTMLHelperCaller;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class BTMLVisitorPreOrderTraversalIterative {
    protected Stack<Action> _stack;
    protected Activity _treeRoot;
    protected Diagram _treeDiag;
    protected BTMLHelperCaller _helperCaller;

    protected Diagram getBtDiagram(Activity aa) throws Exception {
        Diagram diag = null;
        this._helperCaller.setUpOperation("getBtDiagram");
        diag = this._helperCaller.getBtDiagram(aa);
        this._helperCaller.setUpOperation("getBtNodeChildrenOrdered");
        return diag;
    }

    protected void stack_push(LinkedHashSet<Action> ordset) {
        LinkedList<Action> ordlist = new LinkedList<Action>(ordset);
        Iterator<Action> itr = ordlist.descendingIterator();
        while (itr.hasNext()) {
            this._stack.push(itr.next());
        }
    }

    protected void validateTreeRoot(Activity next) throws Exception {
        if (next != this._treeRoot) {
            this._treeRoot = next;
            this._treeDiag = this.getBtDiagram(next);
        }
    }

    public BTMLVisitorPreOrderTraversalIterative(Activity tr) throws Exception {
        this._treeRoot = tr;
        this._stack = new Stack();
        TreeRoot tr_ = (TreeRoot)UMLUtil.getStereotypeApplication((Element)tr, TreeRoot.class);
        this._stack.push(tr_.getTreenode().getBase_Action());
        this._helperCaller = new BTMLHelperCaller();
        this._helperCaller.setUp();
        this._treeDiag = this.getBtDiagram(this._treeRoot);
    }

    public void dispose() {
        this._helperCaller.dispose();
    }

    public boolean hasNext() {
        return !this._stack.empty();
    }

    public Action visitNext() throws Exception {
        Action next = this._stack.pop();
        this.validateTreeRoot(next.getActivity());
        LinkedHashSet<Action> next_children = this._helperCaller.getBtNodeChildrenOrdered(next, this._treeDiag);
        if (next_children.size() > 0) {
            this.stack_push(next_children);
        }
        return next;
    }
}

