/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.fromfile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.internal.core.model.ASTStringUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.languages.common.base.StringUtils;
import org.eclipse.papyrus.designer.languages.common.base.UriConstants;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterEntry;
import org.eclipse.papyrus.robotics.ros2.reverse.ParamInfo;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class ReverseParametersFromSource {
    private static final String ADD_PARAMETER = "add_parameter";
    private static final String GET_PARAMETER = "get_parameter";
    private static final String DECLARE_PARAMETER = "declare_parameter";
    protected Class component;
    protected IASTTranslationUnit ast;
    protected List<ParamInfo> paramInfos;
    protected Map<String, ParamInfo> paramInfoMap;

    public ReverseParametersFromSource(Class component, IASTTranslationUnit ast) {
        this.component = component;
        this.ast = ast;
        this.paramInfoMap = new HashMap<String, ParamInfo>();
        this.paramInfos = new ArrayList<ParamInfo>();
    }

    public ParamInfo getParamInfo(String paramName) {
        ParamInfo paramInfo = this.paramInfoMap.get(paramName);
        if (paramInfo == null) {
            paramInfo = new ParamInfo();
            this.paramInfos.add(paramInfo);
            this.paramInfoMap.put(paramName, paramInfo);
        }
        return paramInfo;
    }

    public List<ParamInfo> getParamInfos() {
        return this.paramInfos;
    }

    public void updateParameters() {
        Class paramSet = ParameterUtils.getParameterClass((Class)this.component);
        this.scanFunctions((IASTNode)this.ast);
        for (ParamInfo pi : this.paramInfos) {
            Property paramUML = paramSet.createOwnedAttribute(pi.name, pi.type);
            ParameterEntry entry = (ParameterEntry)StereotypeUtil.applyApp((Element)paramUML, ParameterEntry.class);
            if (pi.defaultValue != null) {
                paramUML.setDefault(pi.defaultValue);
            }
            if (pi.description == null) continue;
            entry.setDescription(pi.description);
        }
    }

    public void scanFunctions(IASTNode node) {
        IASTNode[] iASTNodeArray = node.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            if (child instanceof IASTFunctionDefinition) {
                IASTFunctionDefinition definition = (IASTFunctionDefinition)child;
                this.scanBody((IASTNode)definition.getBody());
            }
            if (child instanceof ICPPASTNamespaceDefinition) {
                this.scanFunctions(child);
            }
            ++n2;
        }
    }

    public static String getASTName(IASTExpression expr) {
        if (expr instanceof IASTFieldReference) {
            IASTName fieldName = ((IASTFieldReference)expr).getFieldName();
            if (fieldName != null) {
                return fieldName.toString();
            }
            return "";
        }
        return expr.toString();
    }

    public static EParam getProviderFromCall(String fctName) {
        if (fctName.equals(DECLARE_PARAMETER)) {
            return EParam.ADD_OR_DECLARE;
        }
        if (fctName.equals(ADD_PARAMETER)) {
            return EParam.ADD_OR_DECLARE;
        }
        if (fctName.equals(GET_PARAMETER)) {
            return EParam.GET_PARAM;
        }
        return EParam.NONE;
    }

    public static String deduceDefaultValue(IASTFunctionCallExpression fCallExpr) {
        IASTInitializerClause[] arguments = fCallExpr.getArguments();
        if (arguments.length > 0) {
            if (arguments[0] instanceof IASTLiteralExpression) {
                return StringUtils.unquote((String)arguments[0].toString());
            }
            if (arguments[0] instanceof IASTUnaryExpression) {
                IASTUnaryExpression unaryExpr = (IASTUnaryExpression)arguments[0];
                return ASTStringUtil.getExpressionString((IASTExpression)unaryExpr);
            }
            if (arguments[0] instanceof IASTFunctionCallExpression) {
                return ReverseParametersFromSource.deduceDefaultValue((IASTFunctionCallExpression)arguments[0]);
            }
        }
        return null;
    }

    public void obtainDeclOrAddDetails(IASTFunctionCallExpression fCallExpr) {
        IASTInitializerClause[] arguments = fCallExpr.getArguments();
        String paramName = StringUtils.unquote((String)arguments[0].toString());
        String defaultValue = null;
        String description = null;
        if (arguments.length > 1 && arguments[1] instanceof IASTFunctionCallExpression) {
            defaultValue = ReverseParametersFromSource.deduceDefaultValue((IASTFunctionCallExpression)arguments[1]);
        }
        if (arguments.length > 2) {
            description = StringUtils.unquote((String)arguments[2].toString());
        }
        ParamInfo paramInfo = this.getParamInfo(paramName);
        paramInfo.name = paramName;
        paramInfo.description = description;
        paramInfo.defaultValue = defaultValue;
    }

    public void obtainGetDetails(IASTFunctionCallExpression fCallExpr) {
        IASTInitializerClause[] arguments = fCallExpr.getArguments();
        String paramName = arguments[0].toString().trim();
        paramName = StringUtils.unquote((String)paramName);
        String typeName = null;
        if (arguments.length > 1 && arguments[1] instanceof IASTIdExpression) {
            IASTIdExpression id = (IASTIdExpression)arguments[1];
            IBinding binding = id.getName().resolveBinding();
            IType type = ((IField)binding).getType();
            typeName = type instanceof ICPPBinding ? ASTTypeUtil.getQualifiedName((ICPPBinding)((ICPPBinding)type)) : type.toString();
        }
        if (typeName != null) {
            ResourceSet rs = this.component.eResource().getResourceSet();
            PackageUtil.loadPackage((URI)UriConstants.UML_PRIMITIVE_TYPES, (ResourceSet)rs);
            PackageUtil.loadPackage((URI)URI.createURI((String)"pathmap://ROS2_LIBRARY/ros2Library.uml"), (ResourceSet)rs);
            NamedElement ne = ElementUtils.getQualifiedElementFromRS((Element)this.component, typeName);
            if (ne == null) {
                String qName = "AnsiCLibrary::" + typeName;
                ne = ElementUtils.getQualifiedElementFromRS((Element)this.component, (String)qName);
            }
            if (ne == null) {
                NamedElement stdlib;
                String shortName = null;
                if (typeName.equals("std::__cxx11::string")) {
                    shortName = "string";
                } else if (typeName.equals("std::vector<string,allocator<string>>")) {
                    shortName = "vector<std::string>";
                }
                if (shortName != null && (stdlib = ElementUtils.getQualifiedElementFromRS((Element)this.component, (String)"ros2Library::stdlib")) instanceof Package) {
                    ne = ((Package)stdlib).getMember(shortName);
                }
            }
            if (ne instanceof Type) {
                ParamInfo paramInfo = this.getParamInfo(paramName);
                paramInfo.name = paramName;
                paramInfo.type = (Type)ne;
            } else {
                Activator.log.debug(String.format("Cannot find type %s", typeName));
            }
        }
    }

    public void scanBody(IASTNode node) {
        IASTFunctionCallExpression fCallExpr;
        IASTExpression nameExpr;
        if (node instanceof IASTFunctionCallExpression && (nameExpr = (fCallExpr = (IASTFunctionCallExpression)node).getFunctionNameExpression()) instanceof IASTIdExpression) {
            IASTIdExpression nameId = (IASTIdExpression)nameExpr;
            IASTName astName = nameId.getName();
            String fctName = astName.toString();
            EParam param = ReverseParametersFromSource.getProviderFromCall(fctName);
            if (param == EParam.ADD_OR_DECLARE) {
                this.obtainDeclOrAddDetails(fCallExpr);
            } else if (param == EParam.GET_PARAM) {
                this.obtainGetDetails(fCallExpr);
            }
        }
        IASTNode[] iASTNodeArray = node.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            this.scanBody(child);
            ++n2;
        }
    }

    static enum EParam {
        ADD_OR_DECLARE,
        GET_PARAM,
        NONE;

    }
}

