/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.dashboard.ui.pages;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.robotics.dashboard.ui.pages.ModelExtensionFilter;
import org.eclipse.papyrus.robotics.wizards.wizards.NewRoboticsModelWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class P4RProjectModelHyperlink {
    public static void create(FormToolkit toolkit, Composite sectionClient, String text, Image image, final String wizardConstant, final boolean isProject) {
        ImageHyperlink i = toolkit.createImageHyperlink(sectionClient, 64);
        i.setImage(image);
        i.setText(text);
        i.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String id = null;
                id = isProject ? "org.eclipse.papyrus.robotics.wizards.createproject" : "org.eclipse.papyrus.robotics.wizards.createmodel";
                IWizardDescriptor descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(id);
                try {
                    IWorkbenchWizard wizard = descriptor.createWizard();
                    NewRoboticsModelWizard wi = (NewRoboticsModelWizard)wizard;
                    IWorkbench vWorkbench = PlatformUI.getWorkbench();
                    wi.init(vWorkbench, (IStructuredSelection)StructuredSelection.EMPTY);
                    WizardDialog wd = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                    wd.setTitle(wizard.getWindowTitle());
                    wd.create();
                    wi.setViewpoint(wizardConstant);
                    wd.showPage(wd.getCurrentPage().getNextPage());
                    wd.open();
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    public static void open(FormToolkit toolkit, Composite sectionClient, String text, Image image, final String fileExtensionConstant) {
        ImageHyperlink i = toolkit.createImageHyperlink(sectionClient, 64);
        i.setImage(image);
        i.setText(text);
        i.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ElementTreeSelectionDialog dialogOpenComponent = new ElementTreeSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                dialogOpenComponent.addFilter((ViewerFilter)new ModelExtensionFilter(fileExtensionConstant));
                dialogOpenComponent.setTitle("Model Selection");
                dialogOpenComponent.setMessage("Select the element from the tree:");
                dialogOpenComponent.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                if (dialogOpenComponent.open() == 0) {
                    IFile file = (IFile)dialogOpenComponent.getFirstResult();
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
                    try {
                        page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
                    }
                    catch (PartInitException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
    }

    public static void openAndShowMessage(FormToolkit toolkit, Composite sectionClient, String text, Image image, final String FileExtensionConstant, final String msg_text) {
        ImageHyperlink i = toolkit.createImageHyperlink(sectionClient, 64);
        i.setImage(image);
        i.setText(text);
        i.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ElementTreeSelectionDialog dialogOpenComponent = new ElementTreeSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                dialogOpenComponent.addFilter((ViewerFilter)new ModelExtensionFilter(FileExtensionConstant));
                dialogOpenComponent.setTitle("Model Selection");
                dialogOpenComponent.setMessage("Select the element from the tree:");
                dialogOpenComponent.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                if (dialogOpenComponent.open() == 0) {
                    IFile file = (IFile)dialogOpenComponent.getFirstResult();
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Info", (String)msg_text);
                    try {
                        page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
                    }
                    catch (PartInitException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
    }
}

