/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.xtext.datatypes.ui.contribution;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.robotics.profile.robotics.commobject.DataAttribute;
import org.eclipse.papyrus.robotics.xtext.datatypes.dTML.XDataType;
import org.eclipse.papyrus.robotics.xtext.datatypes.ui.contribution.UnparseDT;
import org.eclipse.papyrus.robotics.xtext.datatypes.ui.internal.DatatypesActivator;
import org.eclipse.papyrus.robotics.xtext.util.TrackNames;
import org.eclipse.papyrus.robotics.xtext.util.UpdateContextAdapter;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.BoundSpecification;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.MultiplicityRule;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.TypeRule;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.uml.xtext.integration.AbstractXtextDirectEditorConfiguration;
import org.eclipse.papyrus.uml.xtext.integration.InvalidStringUtil;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLFactory;

public class DataTypeEditorConfigurationContribution
extends AbstractXtextDirectEditorConfiguration {
    TrackNames<Property> lastAttributes;

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof DataType) {
            DataType dt = (DataType)editedObject;
            String invalidStr = InvalidStringUtil.getTextualRepresentation((Element)dt);
            if (invalidStr != null) {
                return invalidStr;
            }
            return UnparseDT.getDTtext(dt).toString();
        }
        return "Unexpected editor object";
    }

    public Object preEditAction(Object objectToEdit) {
        if (objectToEdit instanceof DataType) {
            DataType umlDt = (DataType)objectToEdit;
            this.lastAttributes = new TrackNames(umlDt.getOwnedAttributes());
        }
        return super.preEditAction(objectToEdit);
    }

    public ContextElementAdapter.IContextElementProvider getContextProvider() {
        return new UpdateContextAdapter(this.objectToEdit){

            public void updateLastNames() {
                XDataType dtm = (XDataType)this.xtextResource.getContents().get(0);
                ArrayList<String> attrNameList = new ArrayList<String>();
                for (org.eclipse.papyrus.robotics.xtext.datatypes.dTML.Property dtAttribute : dtm.getAttributes()) {
                    attrNameList.add(dtAttribute.getName());
                }
                DataTypeEditorConfigurationContribution.this.lastAttributes.update(attrNameList);
            }
        };
    }

    public int getStyle() {
        return 66;
    }

    public Injector getInjector() {
        return DatatypesActivator.getInstance().getInjector("org.eclipse.papyrus.robotics.xtext.datatypes.DTML");
    }

    public ICommand getParseCommand(EObject umlObject, EObject xtextObject) {
        TransactionalEditingDomain dom = TransactionUtil.getEditingDomain((EObject)umlObject);
        if (umlObject instanceof DataType) {
            DataType dt = (DataType)umlObject;
            if (xtextObject instanceof XDataType) {
                CompositeCommand cc = new CompositeCommand("Update data type");
                for (Property umlAttribute : Lists.newArrayList((Iterable)dt.getOwnedAttributes())) {
                    if (this.lastAttributes.containsValue((NamedElement)umlAttribute)) continue;
                    DestroyElementRequest destroyReq = new DestroyElementRequest((EObject)umlAttribute, false);
                    ICommand destroyCmd = ElementEditServiceUtils.getCommandProvider((EObject)dt).getEditCommand((IEditCommandRequest)destroyReq);
                    cc.add((IUndoableOperation)destroyCmd);
                }
                UpdateDataTypeCommand updateCommand = new UpdateDataTypeCommand(dom, dt, (XDataType)xtextObject);
                cc.add((IUndoableOperation)updateCommand);
                return cc;
            }
        }
        return null;
    }

    protected class UpdateDataTypeCommand
    extends AbstractTransactionalCommand {
        private DataType dt;
        private XDataType xDT;

        public UpdateDataTypeCommand(TransactionalEditingDomain domain, DataType dt, XDataType xDT) {
            super(domain, "Update datatype", UpdateDataTypeCommand.getWorkspaceFiles((EObject)dt));
            this.dt = dt;
            this.xDT = xDT;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            this.dt.setName(this.xDT.getName());
            this.dt.getOwnedAttributes().clear();
            for (org.eclipse.papyrus.robotics.xtext.datatypes.dTML.Property dtAttribute : this.xDT.getAttributes()) {
                TypeRule typeRule = dtAttribute.getType();
                MultiplicityRule mRule = dtAttribute.getMultiplicity();
                Property umlAttribute = (Property)DataTypeEditorConfigurationContribution.this.lastAttributes.get(dtAttribute.getName());
                if (umlAttribute == null) {
                    umlAttribute = UMLFactory.eINSTANCE.createProperty();
                }
                umlAttribute.setName(dtAttribute.getName());
                umlAttribute.setType(typeRule != null ? typeRule.getType() : null);
                if (mRule != null) {
                    if (mRule.getBounds().size() > 0) {
                        String upperStr = ((BoundSpecification)mRule.getBounds().get(0)).getValue();
                        umlAttribute.setLower(0);
                        if (upperStr.equals("*")) {
                            umlAttribute.setUpper(-1);
                        } else {
                            umlAttribute.setUpper(Integer.parseInt(upperStr));
                        }
                    }
                } else {
                    umlAttribute.setLower(1);
                    umlAttribute.setUpper(1);
                }
                this.dt.getOwnedAttributes().add((Object)umlAttribute);
                DataAttribute da = (DataAttribute)StereotypeUtil.applyApp((Element)umlAttribute, DataAttribute.class);
                String comment = dtAttribute.getComment();
                if (da == null || comment == null) continue;
                comment = comment.substring(2).trim();
                da.setDescription(comment);
            }
            return CommandResult.newOKCommandResult((Object)this.dt);
        }
    }
}

