/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.validation.constraints;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.robotml.validation.constraints.ConstraintsUtil;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class OnlyOneConnectionBetweenTwoPorts
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        Connector elt = (Connector)ctx.getTarget();
        if (ConstraintsUtil.verifyRobotMLApplied((Element)elt).booleanValue()) {
            EList cends = new ArrayList();
            cends = elt.getEnds();
            if (cends != null && cends.size() == 2 && cends.get(0) instanceof ConnectorEnd && cends.get(1) instanceof ConnectorEnd) {
                ConnectableElement connectorEndRole0 = ((ConnectorEnd)cends.get(0)).getRole();
                ConnectableElement connectorEndRole1 = ((ConnectorEnd)cends.get(1)).getRole();
                Property partWithPort0 = ((ConnectorEnd)cends.get(0)).getPartWithPort();
                Property partWithPort1 = ((ConnectorEnd)cends.get(1)).getPartWithPort();
                if (connectorEndRole0 instanceof Port && connectorEndRole1 instanceof Port) {
                    EList port1Ends = new ArrayList();
                    EList port0Ends = new ArrayList();
                    port0Ends = connectorEndRole0.getEnds();
                    port1Ends = connectorEndRole1.getEnds();
                    for (ConnectorEnd end0 : port0Ends) {
                        for (ConnectorEnd end1 : port1Ends) {
                            if (!end0.eContainer().equals(end1.eContainer()) || end0.eContainer().equals(elt) || !end0.getPartWithPort().equals(partWithPort0) || !end1.getPartWithPort().equals(partWithPort1)) continue;
                            return ctx.createFailureStatus(new Object[]{"Connection must be set between ports that are not already connected. There is already a connector named : " + ((Connector)end0.eContainer()).getQualifiedName()});
                        }
                    }
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

