/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.validation.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.RobotML.DataFlowPort;
import org.eclipse.papyrus.RobotML.ServicePort;
import org.eclipse.papyrus.robotml.validation.constraints.ConstraintsUtil;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PortIsCorrectlyTyped
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        Port elt = (Port)ctx.getTarget();
        if (ConstraintsUtil.verifyRobotMLApplied((Element)elt).booleanValue()) {
            if (elt.getType() == null) {
                return ctx.createFailureStatus(new Object[]{"Port should have a type (" + elt.getQualifiedName() + ")"});
            }
            ServicePort serviceport = (ServicePort)UMLUtil.getStereotypeApplication((Element)elt, ServicePort.class);
            if (serviceport != null) {
                if (!(elt.getType() instanceof Interface)) {
                    return ctx.createFailureStatus(new Object[]{"Port should be typed by an Interface (" + elt.getQualifiedName() + ")"});
                }
            } else {
                DataFlowPort flowport = (DataFlowPort)UMLUtil.getStereotypeApplication((Element)elt, DataFlowPort.class);
                if (flowport != null && !(elt.getType() instanceof DataType)) {
                    return ctx.createFailureStatus(new Object[]{"Port should be typed by a DataType (" + elt.getQualifiedName() + ")"});
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

