/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment;

import java.util.Iterator;
import org.eclipse.papyrus.RobotML.DeploymentPlan;
import org.eclipse.papyrus.robotml.deployment.Activator;
import org.eclipse.papyrus.robotml.deployment.DepCreation;
import org.eclipse.papyrus.robotml.deployment.DepPlanUtils;
import org.eclipse.papyrus.robotml.deployment.DepUtils;
import org.eclipse.papyrus.robotml.deployment.StUtils;
import org.eclipse.papyrus.robotml.deployment.TransformationException;
import org.eclipse.papyrus.robotml.deployment.Utils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;

public class DepPlanSync {
    public static void syncAllDepPlans(Element element) {
        for (Package depPlan : DepPlanUtils.getAllDepPlans(element)) {
            DepPlanSync.syncDepPlan(depPlan);
        }
    }

    public static void syncDepPlan(Package depPlan) {
        DepPlanSync.removeUnusedSlots(depPlan);
        DeploymentPlan cdp = StUtils.getApplication((Element)depPlan, DeploymentPlan.class);
        if (cdp == null) {
            return;
        }
        InstanceSpecification mainInstance = cdp.getMainInstance();
        DepPlanSync.addCDP(depPlan, mainInstance, mainInstance.getName());
    }

    private static void addCDP(Package depPlan, InstanceSpecification instance, String canonicalName) {
        Class implementation = DepUtils.getImplementation(instance);
        if (!instance.getName().equals(canonicalName)) {
            instance.setName(canonicalName);
        }
        for (Slot slot : instance.getSlots()) {
            InstanceSpecification subInstance = DepUtils.getInstance(slot);
            if (subInstance == null) continue;
            DepPlanSync.addCDP(depPlan, subInstance, String.valueOf(canonicalName) + "." + slot.getDefiningFeature().getName());
        }
        for (Property attribute : Utils.getParts(implementation)) {
            Type type = attribute.getType();
            if (!(type instanceof Class) || DepPlanSync.hasSlot(instance, attribute)) continue;
            try {
                InstanceSpecification partIS = DepCreation.createDepPlan(depPlan, (Class)type, String.valueOf(instance.getName()) + "." + attribute.getName(), true);
                DepPlanUtils.createSlot(depPlan, instance, partIS, attribute);
            }
            catch (TransformationException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    private static boolean hasSlot(InstanceSpecification instance, Property attribute) {
        for (Slot slot : instance.getSlots()) {
            if (slot.getDefiningFeature() != attribute) continue;
            return true;
        }
        return false;
    }

    public static void removeUnusedSlots(Package depPlan) {
        for (NamedElement member : depPlan.getMembers()) {
            if (!(member instanceof InstanceSpecification)) continue;
            InstanceSpecification instance = (InstanceSpecification)member;
            Iterator slotIt = instance.getSlots().iterator();
            while (slotIt.hasNext()) {
                Slot slot = (Slot)slotIt.next();
                if (slot.getDefiningFeature() != null) continue;
                for (ValueSpecification value : slot.getValues()) {
                    if (!(value instanceof InstanceValue)) continue;
                    InstanceSpecification is = ((InstanceValue)value).getInstance();
                    DepPlanUtils.delDepPlan(is);
                }
                slot.destroy();
                slotIt.remove();
            }
        }
    }
}

