/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.robotml.deployment.Copy;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StUtils {
    public static boolean isApplied(Element element, String str_name) {
        return element.getAppliedStereotype(str_name) != null;
    }

    public static boolean isApplied(Element element, Class<? extends EObject> clazz) {
        for (EObject stereoApplication : element.getStereotypeApplications()) {
            if (!clazz.isAssignableFrom(stereoApplication.getClass())) continue;
            return true;
        }
        return false;
    }

    public static Object getAttribute(Element element, String stereo_name, String attrib_name) {
        Stereotype stereotype = element.getAppliedStereotype(stereo_name);
        if (stereotype == null) {
            return null;
        }
        return element.getValue(stereotype, attrib_name);
    }

    public static void setAttribute(Element element, String stereo_name, String attr_name, Object value) {
        Stereotype st = StUtils.apply(element, stereo_name);
        if (st != null) {
            element.setValue(st, attr_name, value);
        }
    }

    public static EObject getApplication(Element element, String stereo_name) {
        Stereotype stereotype = element.getApplicableStereotype(stereo_name);
        if (stereotype != null) {
            EObject application = element.getStereotypeApplication(stereotype);
            if (application != null) {
                return application;
            }
            for (Stereotype subStereo : element.getAppliedSubstereotypes(stereotype)) {
                application = element.getStereotypeApplication(subStereo);
                if (application == null) continue;
                return application;
            }
        }
        return null;
    }

    public static <T extends EObject> T getApplication(Element element, Class<T> clazz) {
        for (EObject stereoApplication : element.getStereotypeApplications()) {
            if (!clazz.isInstance(stereoApplication)) continue;
            return (T)stereoApplication;
        }
        return null;
    }

    public static Stereotype apply(Element element, String stereo_name) {
        Stereotype stereotype = element.getApplicableStereotype(stereo_name);
        if (stereotype != null) {
            boolean alreadyApplied;
            EList subStereos = element.getAppliedSubstereotypes(stereotype);
            boolean bl = alreadyApplied = subStereos.size() > 0;
            if (!alreadyApplied && element.getStereotypeApplication(stereotype) == null) {
                element.applyStereotype(stereotype);
            }
        }
        return stereotype;
    }

    public static void unapply(Element element, String stereo_name) {
        Stereotype stereotype = element.getApplicableStereotype(stereo_name);
        if (stereotype != null && element.getStereotypeApplication(stereotype) != null) {
            element.unapplyStereotype(stereotype);
        }
    }

    public static <T extends EObject> T applyApp(Element element, Class<T> clazz) {
        if (StUtils.apply(element, clazz) != null) {
            return StUtils.getApplication(element, clazz);
        }
        return null;
    }

    public static Stereotype applyExact(Element element, String stereo_name) {
        Stereotype alreadyApplied;
        Stereotype stereotype = element.getApplicableStereotype(stereo_name);
        if (stereotype != null && (alreadyApplied = element.getAppliedSubstereotype(stereotype, stereo_name)) == null) {
            element.applyStereotype(stereotype);
        }
        return stereotype;
    }

    public static Stereotype apply(Element element, Class<? extends EObject> clazz) {
        return StUtils.apply(element, StUtils.getStereoName(element, clazz));
    }

    public static void unapply(Element element, Class<? extends EObject> clazz) {
        StUtils.unapply(element, StUtils.getStereoName(element, clazz));
    }

    public static Stereotype applyExact(Element element, Class<? extends EObject> clazz) {
        return StUtils.applyExact(element, StUtils.getStereoName(element, clazz));
    }

    public static Element getAttributeBase(Element element, String stereo_name, String attrib_name) {
        Object obj = StUtils.getAttribute(element, stereo_name, attrib_name);
        if (obj instanceof EObject) {
            return UMLUtil.getBaseElement((EObject)((EObject)obj));
        }
        return null;
    }

    public static void copyStereotypes(Copy copy, Element source, Element destination) {
        for (Stereotype stereotype : source.getAppliedStereotypes()) {
            stereotype.getQualifiedName();
            StUtils.copyAttributes(copy, stereotype.getQualifiedName(), source, destination);
        }
    }

    public static void copyStereotypes(Element source, Element destination) {
        StUtils.copyStereotypes(null, source, destination);
    }

    public static boolean copyAttributes(Copy copy, String stereotypeName, Element source, Element destination) {
        Stereotype stereoSource = source.getAppliedStereotype(stereotypeName);
        Stereotype stereoDest = destination.getApplicableStereotype(stereotypeName);
        if (stereoSource == null || stereoDest == null) {
            return false;
        }
        Stereotype alreadyApplied = destination.getAppliedStereotype(stereotypeName);
        if (alreadyApplied == null) {
            destination.applyStereotype(stereoDest);
        }
        for (Property attribute : stereoSource.getAllAttributes()) {
            String attrName = attribute.getName();
            if (attrName.length() >= 5 && attrName.startsWith("base_") || attribute.isDerived()) continue;
            Object value = source.getValue(stereoSource, attrName);
            if (value instanceof EList) {
                BasicEList newList = new BasicEList();
                for (Object valueEl : (EList)value) {
                    if (copy != null && valueEl instanceof Element) {
                        newList.add((Object)copy.getCopy((Element)valueEl));
                        continue;
                    }
                    newList.add(valueEl);
                }
                if (newList.size() <= 0) continue;
                destination.setValue(stereoDest, attrName, (Object)newList);
                continue;
            }
            if (copy != null && value instanceof Element) {
                destination.setValue(stereoDest, attrName, (Object)copy.getCopy((Element)value));
                continue;
            }
            destination.setValue(stereoDest, attrName, value);
        }
        return true;
    }

    public static boolean copyAttribute(String stereotypeName, String attribute, Element source, Element destination) {
        Stereotype stereotype = source.getAppliedStereotype(stereotypeName);
        if (stereotype == null) {
            return false;
        }
        Object value = source.getValue(stereotype, attribute);
        destination.applyStereotype(stereotype);
        destination.setValue(stereotype, attribute, value);
        return true;
    }

    public static Stereotype getStereo(Element element, Class<? extends EObject> clazz) {
        return element.getAppliedStereotype(StUtils.getStereoName(element, clazz));
    }

    public static String getStereoName(Element element, Class<? extends EObject> clazz) {
        String name = clazz.getName().replace(".", "::");
        while (element.getApplicableStereotype(name) == null) {
            int index = name.indexOf("::");
            if (index == -1) {
                return null;
            }
            name = name.substring(index + 2);
        }
        return name;
    }
}

