/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.generators.intempora.rtmaps.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.robotml.generators.intempora.rtmaps.ui.Activator;
import org.eclipse.papyrus.robotml.generators.intempora.rtmaps.ui.handler.GenerateRTMapsCodeCommand;
import org.eclipse.ui.handlers.HandlerUtil;

public class AcceleoGenerateRTMapsCommandHandler
extends AbstractHandler {
    private final String rtmapsFolder = "rtmaps-generated-files";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            EObject selectedElement = EMFHelper.getEObject((Object)structuredSelection.getFirstElement());
            if (selectedElement == null) {
                return null;
            }
            URI resourceURI = selectedElement.eResource().getURI();
            URI targetFolderURI = resourceURI.trimSegments(1).appendSegment("rtmaps-generated-files");
            try {
                TransactionalEditingDomain editingDomain = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)selectedElement);
                GenerateRTMapsCodeCommand generationCommand = new GenerateRTMapsCodeCommand("Generate RTMaps code command", editingDomain, selectedElement, targetFolderURI.toPlatformString(true));
                if (generationCommand.canExecute()) {
                    generationCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        return null;
    }
}

