/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomBooleanStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.NamedStyleProperties;
import org.eclipse.papyrus.uml.diagram.common.editparts.AbstractExternalLabelEditPart;
import org.eclipse.papyrus.uml.diagram.common.editparts.IFloatingLabelEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.MaskManagedFloatingLabelEditPolicy;

public abstract class AbstractFloatingLabelEditPart
extends AbstractExternalLabelEditPart
implements NamedStyleProperties,
IFloatingLabelEditPart {
    private static final boolean DEFAULT_LABEL_DISPLAYED = false;
    private IObservableValue<?> labelDisplayedObservable;
    private IChangeListener namedStyleListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            AbstractFloatingLabelEditPart.this.refresh();
        }
    };

    public AbstractFloatingLabelEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("INDRIRECT_MASK_MANAGED_LABEL", (EditPolicy)new MaskManagedFloatingLabelEditPolicy());
    }

    protected void refreshVisibility() {
        super.refreshVisibility();
        boolean isLabelDisplayed = NotationUtils.getBooleanValue((View)((View)this.getModel()), (String)"visible", (boolean)this.getDefaultLabelVisibility());
        this.getFigure().setVisible(isLabelDisplayed);
    }

    protected boolean getDefaultLabelVisibility() {
        return false;
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        this.labelDisplayedObservable = new CustomBooleanStyleObservableValue((View)this.getModel(), EMFHelper.resolveEditingDomain((Object)this.getModel()), "visible");
        this.labelDisplayedObservable.addChangeListener(this.namedStyleListener);
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.labelDisplayedObservable.dispose();
    }
}

