/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.uml.diagram.common.commands.FixPortLocationCommand;
import org.eclipse.papyrus.uml.diagram.common.commands.ResizeParentFigureCommand;
import org.eclipse.papyrus.uml.diagram.common.commands.UpdatePortLocationCommand;
import org.eclipse.papyrus.uml.diagram.common.editparts.RoundedBorderNamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;

public class PortResizableEditPolicy
extends BorderItemResizableEditPolicy {
    protected Command getResizeCommand(ChangeBoundsRequest request) {
        boolean resizable;
        CompoundCommand resizeCommand = new CompoundCommand("Resize command");
        Object model = ((GraphicalEditPart)this.getHost()).getModel();
        if (model instanceof View && (resizable = NotationUtils.getBooleanValue((View)((View)model), (String)"isPortResizable", (boolean)false))) {
            CompoundCommand updatePortLocationsCommand = new CompoundCommand("Update border test location");
            CompoundCommand fixPortLocationsCommand = new CompoundCommand("Fix border items location");
            Command res = this.getResizePortCommand(request);
            if (request.getEditParts() != null) {
                for (Object object : request.getEditParts()) {
                    UpdatePortLocationCommand updatePortLocationCommand;
                    if (!(object instanceof RoundedBorderNamedElementEditPart)) continue;
                    RoundedBorderNamedElementEditPart editpart = (RoundedBorderNamedElementEditPart)object;
                    Shape view = (Shape)editpart.getNotationView();
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)view);
                    ResizeParentFigureCommand updatePortSize = new ResizeParentFigureCommand(editingDomain, (DefaultSizeNodeFigure)editpart.getPrimaryShape().getParent(), request);
                    resizeCommand.add((Command)new ICommandProxy((ICommand)updatePortSize));
                    FixPortLocationCommand fixPortLocationCommand = new FixPortLocationCommand(editingDomain, (IBorderItemEditPart)editpart, (GraphicalEditPart)this.getHost());
                    if (fixPortLocationCommand.canExecute()) {
                        fixPortLocationsCommand.add((Command)new ICommandProxy((ICommand)fixPortLocationCommand));
                    }
                    if (!(updatePortLocationCommand = new UpdatePortLocationCommand(editingDomain, request, (GraphicalEditPart)this.getHost(), (IBorderItemEditPart)editpart, editpart.getBorderItemLocator().getCurrentSideOfParent())).canExecute()) continue;
                    updatePortLocationsCommand.add((Command)new ICommandProxy((ICommand)updatePortLocationCommand));
                }
                if (!fixPortLocationsCommand.isEmpty()) {
                    resizeCommand.add((Command)fixPortLocationsCommand);
                }
                if (!updatePortLocationsCommand.isEmpty()) {
                    resizeCommand.add((Command)updatePortLocationsCommand);
                }
                resizeCommand.add(res);
            }
        }
        return resizeCommand.isEmpty() ? null : resizeCommand;
    }

    protected Command getResizePortCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
        req.setCenteredResize(request.isCenteredResize());
        req.setConstrainedMove(request.isConstrainedMove());
        req.setConstrainedResize(request.isConstrainedResize());
        req.setSnapToEnabled(request.isSnapToEnabled());
        req.setEditParts((EditPart)this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        req.setResizeDirection(request.getResizeDirection());
        if (this.getHost().getParent() == null) {
            return null;
        }
        if (request.getEditParts() == null) {
            return null;
        }
        for (Object object : request.getEditParts()) {
            if (!(object instanceof RoundedBorderNamedElementEditPart)) continue;
            RoundedBorderNamedElementEditPart editPart = (RoundedBorderNamedElementEditPart)object;
            int w = editPart.getFigure().getBounds().width + request.getSizeDelta().width;
            int h = editPart.getFigure().getBounds().height + request.getSizeDelta().height;
            int wdelta = 20 - editPart.getFigure().getBounds().width;
            int hdelta = 20 - editPart.getFigure().getBounds().height;
            Dimension sizeDelta = request.getSizeDelta();
            if (w < 20) {
                sizeDelta.setWidth(wdelta);
            }
            if (h < 20) {
                sizeDelta.setHeight(hdelta);
            }
            req.setSizeDelta(sizeDelta);
        }
        Command cm = this.getHost().getParent().getCommand((Request)req);
        return cm;
    }
}

