/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *    Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.diagram.preferences;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.preferences.CustomPage;
import impl.preferences.StandardPage;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.DiagramColors;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FontStyle;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenColor;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenConstantColor;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomFont;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomPreferencePage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagramPreferences;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenFont;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPreferencePage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenRGBColor;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenStandardFont;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenStandardPreferencePage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.JFaceFont;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Routing;
import org.eclipse.papyrus.gmf.codegen.gmfgen.RulerUnits;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.diagram.Utils_qvto;

@Singleton
@SuppressWarnings("all")
public class PreferenceInitializer {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private Utils_qvto _utils_qvto;

  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  private Activator xptActivator;

  @Inject
  private CustomPage xptCustomPage;

  @Inject
  private StandardPage xptStandardPage;

  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("DiagramPreferenceInitializer");
    return _builder;
  }

  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _preferencesPackageName = it.getPreferencesPackageName();
    _builder.append(_preferencesPackageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence PreferenceInitializer(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void initializeDefaultPreferences() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.jface.preference.IPreferenceStore store = getPreferenceStore();");
    _builder.newLine();
    {
      GenDiagramPreferences _preferences = it.getPreferences();
      boolean _tripleEquals = (_preferences == null);
      if (_tripleEquals) {
        {
          List<GenPreferencePage> _allPreferencePages = this._utils_qvto.allPreferencePages(it);
          for(final GenPreferencePage pref : _allPreferencePages) {
            _builder.append("\t\t");
            CharSequence _initDefaults = this.initDefaults(pref, "store");
            _builder.append(_initDefaults, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
      } else {
        {
          Iterable<GenCustomPreferencePage> _filter = Iterables.<GenCustomPreferencePage>filter(this._utils_qvto.allPreferencePages(it), GenCustomPreferencePage.class);
          for(final GenCustomPreferencePage pref_1 : _filter) {
            _builder.append("\t\t");
            CharSequence _initDefaults_1 = this.initDefaults(pref_1, "store");
            _builder.append(_initDefaults_1, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t\t");
        CharSequence _initDefaults_2 = this.initDefaults(it.getPreferences(), "store");
        _builder.append(_initDefaults_2, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.jface.preference.IPreferenceStore getPreferenceStore() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".getInstance().getPreferenceStore();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("} ");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _initDefaults(final GenPreferencePage it, final String storeVar) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Abstract define for " + it));
    return _builder;
  }

  protected CharSequence _initDefaults(final GenStandardPreferencePage it, final String storeVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _call_initDefaults = this.xptStandardPage.call_initDefaults(it, storeVar);
    _builder.append(_call_initDefaults);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _initDefaults(final GenCustomPreferencePage it, final String storeVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _call_initDefaults = this.xptCustomPage.call_initDefaults(it, storeVar);
    _builder.append(_call_initDefaults);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _initDefaults(final GenDiagramPreferences it, final String storeVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(storeVar);
    _builder.append(".setDefault(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_SHOW_CONNECTION_HANDLES, ");
    boolean _isShowConnectionHandles = it.isShowConnectionHandles();
    _builder.append(_isShowConnectionHandles);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append(storeVar);
    _builder.append(".setDefault(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_SHOW_POPUP_BARS, ");
    boolean _isShowPopupBars = it.isShowPopupBars();
    _builder.append(_isShowPopupBars);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append(storeVar);
    _builder.append(".setDefault(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_ENABLE_ANIMATED_LAYOUT, ");
    boolean _isEnableAnimatedLayout = it.isEnableAnimatedLayout();
    _builder.append(_isEnableAnimatedLayout);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append(storeVar);
    _builder.append(".setDefault(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_ENABLE_ANIMATED_ZOOM, ");
    boolean _isEnableAnimatedZoom = it.isEnableAnimatedZoom();
    _builder.append(_isEnableAnimatedZoom);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append(storeVar);
    _builder.append(".setDefault(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_ENABLE_ANTIALIAS, ");
    boolean _isEnableAntiAlias = it.isEnableAntiAlias();
    _builder.append(_isEnableAntiAlias);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    CharSequence _initDefaultFont = this.initDefaultFont(storeVar, "PREF_DEFAULT_FONT", it.getDefaultFont());
    _builder.append(_initDefaultFont);
    _builder.newLineIfNotEmpty();
    CharSequence _initDefaultColor = this.initDefaultColor(storeVar, "PREF_FONT_COLOR", it.getFontColor());
    _builder.append(_initDefaultColor);
    _builder.newLineIfNotEmpty();
    CharSequence _initDefaultColor_1 = this.initDefaultColor(storeVar, "PREF_FILL_COLOR", it.getFillColor());
    _builder.append(_initDefaultColor_1);
    _builder.newLineIfNotEmpty();
    CharSequence _initDefaultColor_2 = this.initDefaultColor(storeVar, "PREF_LINE_COLOR", it.getLineColor());
    _builder.append(_initDefaultColor_2);
    _builder.newLineIfNotEmpty();
    CharSequence _initDefaultColor_3 = this.initDefaultColor(storeVar, "PREF_NOTE_FILL_COLOR", it.getNoteFillColor());
    _builder.append(_initDefaultColor_3);
    _builder.newLineIfNotEmpty();
    CharSequence _initDefaultColor_4 = this.initDefaultColor(storeVar, "PREF_NOTE_LINE_COLOR", it.getNoteLineColor());
    _builder.append(_initDefaultColor_4);
    _builder.newLineIfNotEmpty();
    _builder.append(storeVar);
    _builder.append(".setDefault(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_LINE_STYLE, org.eclipse.gmf.runtime.notation.Routing.");
    Routing _lineStyle = it.getLineStyle();
    _builder.append(_lineStyle);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append(storeVar);
    _builder.append(".setDefault(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_SHOW_RULERS, ");
    boolean _isShowRulers = it.isShowRulers();
    _builder.append(_isShowRulers);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append(storeVar);
    _builder.append(".setDefault(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_RULER_UNITS, org.eclipse.gef.rulers.RulerProvider.UNIT_");
    RulerUnits _rulerUnits = it.getRulerUnits();
    _builder.append(_rulerUnits);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append(storeVar);
    _builder.append(".setDefault(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_SHOW_GRID, ");
    boolean _isShowGrid = it.isShowGrid();
    _builder.append(_isShowGrid);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append(storeVar);
    _builder.append(".setDefault(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_SNAP_TO_GRID, ");
    boolean _isSnapToGrid = it.isSnapToGrid();
    _builder.append(_isSnapToGrid);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append(storeVar);
    _builder.append(".setDefault(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_SNAP_TO_GEOMETRY, ");
    boolean _isSnapToGeometry = it.isSnapToGeometry();
    _builder.append(_isSnapToGeometry);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append(storeVar);
    _builder.append(".setDefault(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_GRID_SPACING, ");
    double _gridSpacing = it.getGridSpacing();
    _builder.append(_gridSpacing);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append(storeVar);
    _builder.append(".setDefault(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_PROMPT_ON_DEL_FROM_MODEL, ");
    boolean _isPromptOnDelFromModel = it.isPromptOnDelFromModel();
    _builder.append(_isPromptOnDelFromModel);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append(storeVar);
    _builder.append(".setDefault(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_PROMPT_ON_DEL_FROM_DIAGRAM, ");
    boolean _isPromptOnDelFromDiagram = it.isPromptOnDelFromDiagram();
    _builder.append(_isPromptOnDelFromDiagram);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence initDefaultColor(final String storeVar, final String prefName, final GenColor color) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((color != null)) {
        _builder.append("org.eclipse.jface.preference.PreferenceConverter.setDefault(");
        _builder.append(storeVar);
        _builder.append(", org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.");
        _builder.append(prefName);
        _builder.append(", ");
        CharSequence _rgb = this.rgb(color);
        _builder.append(_rgb);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence initDefaultFont(final String storeVar, final String prefName, final GenFont font) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((font != null)) {
        _builder.append("org.eclipse.jface.preference.PreferenceConverter.setDefault(");
        _builder.append(storeVar);
        _builder.append(", org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.");
        _builder.append(prefName);
        _builder.append(", ");
        CharSequence _fontData = this.fontData(font);
        _builder.append(_fontData);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _rgb(final GenColor it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Unknown color: " + it));
    return _builder;
  }

  protected CharSequence _rgb(final GenConstantColor it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.figures.DiagramColorConstants.");
    DiagramColors _name = it.getName();
    _builder.append(_name);
    _builder.append(".getRGB()");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _rgb(final GenRGBColor it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.swt.graphics.RGB(");
    int _red = it.getRed();
    _builder.append(_red);
    _builder.append(", ");
    int _green = it.getGreen();
    _builder.append(_green);
    _builder.append(", ");
    int _blue = it.getBlue();
    _builder.append(_blue);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _fontData(final GenFont it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Unknown font: " + it));
    return _builder;
  }

  protected CharSequence _fontData(final GenCustomFont it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.swt.graphics.FontData(\"");
    String _name = it.getName();
    _builder.append(_name);
    _builder.append("\", ");
    int _height = it.getHeight();
    _builder.append(_height);
    _builder.append(", org.eclipse.swt.SWT.");
    FontStyle _style = it.getStyle();
    _builder.append(_style);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _fontData(final GenStandardFont it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.jface.resource.JFaceResources.get");
    JFaceFont _name = it.getName();
    _builder.append(_name);
    _builder.append("Font().getFontData()");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @XbaseGenerated
  public CharSequence initDefaults(final EObject it, final String storeVar) {
    if (it instanceof GenCustomPreferencePage) {
      return _initDefaults((GenCustomPreferencePage)it, storeVar);
    } else if (it instanceof GenStandardPreferencePage) {
      return _initDefaults((GenStandardPreferencePage)it, storeVar);
    } else if (it instanceof GenDiagramPreferences) {
      return _initDefaults((GenDiagramPreferences)it, storeVar);
    } else if (it instanceof GenPreferencePage) {
      return _initDefaults((GenPreferencePage)it, storeVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, storeVar).toString());
    }
  }

  @XbaseGenerated
  public CharSequence rgb(final GenColor it) {
    if (it instanceof GenConstantColor) {
      return _rgb((GenConstantColor)it);
    } else if (it instanceof GenRGBColor) {
      return _rgb((GenRGBColor)it);
    } else if (it != null) {
      return _rgb(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence fontData(final GenFont it) {
    if (it instanceof GenCustomFont) {
      return _fontData((GenCustomFont)it);
    } else if (it instanceof GenStandardFont) {
      return _fontData((GenStandardFont)it);
    } else if (it != null) {
      return _fontData(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
