/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.sirius.properties.uml.Activator;
import org.eclipse.papyrus.uml.tools.profile.definition.Version;
import org.eclipse.uml2.uml.Profile;

public class PropertiesProfileDefinitionServices {
    public static final String EMPTY_STRING = "";
    public static final String PAPYRUS_AUTHOR_KEY = "Author";
    public static final String PAPYRUS_COMMENT_KEY = "Comment";
    public static final String PAPYRUS_COPYRIGHT_KEY = "Copyright";
    public static final String PAPYRUS_DATE_KEY = "Date";
    public static final String PAPYRUS_VERSION_KEY = "Version";
    public static final String PAPYRUS_VERSION = "PapyrusVersion";

    public List<EPackage> getDefinitions(Profile profile) {
        EAnnotation annotation;
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        if (profile != null && (annotation = profile.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")) != null) {
            List filteredEPackages = annotation.getContents().stream().filter(EPackage.class::isInstance).map(EPackage.class::cast).collect(Collectors.toList());
            ePackages.addAll(filteredEPackages);
        }
        return ePackages;
    }

    public String getProfileDefinitionVersion(EPackage definition) {
        Version version = Version.emptyVersion;
        EAnnotation annotation = this.getPapyrusVersionAnnotation(definition);
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)PAPYRUS_VERSION_KEY);
            try {
                version = new Version(Optional.ofNullable(value).orElse(EMPTY_STRING));
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.sirius.properties.uml", "Impossible to parse the version value: " + value, (Throwable)e));
            }
        }
        return version.toString();
    }

    public String getProfileDefinitionDate(EPackage definition) {
        String date = EMPTY_STRING;
        EAnnotation annotation = this.getPapyrusVersionAnnotation(definition);
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)PAPYRUS_DATE_KEY);
            date = Optional.ofNullable(value).orElse(EMPTY_STRING);
        }
        return date;
    }

    public String getProfileDefinitionAuthor(EPackage definition) {
        String author = EMPTY_STRING;
        EAnnotation annotation = this.getPapyrusVersionAnnotation(definition);
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)PAPYRUS_AUTHOR_KEY);
            author = Optional.ofNullable(value).orElse(EMPTY_STRING);
        }
        return author;
    }

    public String getProfileDefinitionCopyright(EPackage definition) {
        String copyright = EMPTY_STRING;
        EAnnotation annotation = this.getPapyrusVersionAnnotation(definition);
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)PAPYRUS_COPYRIGHT_KEY);
            copyright = Optional.ofNullable(value).orElse(EMPTY_STRING);
        }
        return copyright;
    }

    public String getProfileDefinitionComment(EPackage definition) {
        String comment = EMPTY_STRING;
        EAnnotation annotation = this.getPapyrusVersionAnnotation(definition);
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)PAPYRUS_COMMENT_KEY);
            comment = Optional.ofNullable(value).orElse(EMPTY_STRING);
        }
        return comment;
    }

    public boolean removeProfileDefinition(EPackage definition, Profile profile) {
        EAnnotation annotation;
        boolean result = false;
        if (profile != null && definition != null && (annotation = profile.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")) != null) {
            EList contents = annotation.getContents();
            result = contents.remove((Object)definition);
        }
        return result;
    }

    private EAnnotation getPapyrusVersionAnnotation(EPackage definition) {
        EAnnotation annotation = null;
        if (definition != null) {
            annotation = definition.getEAnnotation(PAPYRUS_VERSION);
        }
        return annotation;
    }
}

