/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.uml.service.types.helper.DirectedRelationshipEditHelper;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.UMLPackage;

public class TemplateBindingEditHelper
extends DirectedRelationshipEditHelper {
    @Override
    protected EReference getSourceReference() {
        return UMLPackage.eINSTANCE.getTemplateBinding_BoundElement();
    }

    @Override
    protected EReference getTargetReference() {
        return UMLPackage.eINSTANCE.getTemplateBinding_Signature();
    }

    @Override
    protected boolean canCreate(EObject source, EObject target) {
        TemplateableElement template;
        if (source == null && target == null) {
            return false;
        }
        if (source != null && !(source instanceof TemplateableElement)) {
            return false;
        }
        if (target != null && !(target instanceof TemplateableElement)) {
            return false;
        }
        if (target != null && target instanceof TemplateableElement && ((template = (TemplateableElement)target).getOwnedTemplateSignature() == null || template == source)) {
            return false;
        }
        if (source == null) {
            return true;
        }
        return true;
    }

    @Override
    protected ICommand getConfigureSourcesAndTargetsCommand(final ConfigureRequest req) {
        return new ConfigureElementCommand(req){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                DirectedRelationship element = (DirectedRelationship)req.getElementToConfigure();
                if (req.getParameter("CreateRelationshipRequest.source") != null) {
                    element.eSet((EStructuralFeature)TemplateBindingEditHelper.this.getSourceReference(), TemplateBindingEditHelper.this.getSourceObject(req));
                }
                if (req.getParameter("CreateRelationshipRequest.target") != null) {
                    element.eSet((EStructuralFeature)TemplateBindingEditHelper.this.getTargetReference(), (Object)((TemplateableElement)TemplateBindingEditHelper.this.getTargetObject(req)).getOwnedTemplateSignature());
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
    }

    protected ICommand getReorientRelationshipCommand(ReorientRelationshipRequest request) {
        UnexecutableCommand result = null;
        TemplateBinding binding = (TemplateBinding)request.getRelationship();
        switch (request.getDirection()) {
            case 1: {
                EObject newOwner = request.getNewRelationshipEnd();
                if (!(newOwner instanceof TemplateableElement)) {
                    result = UnexecutableCommand.INSTANCE;
                    break;
                }
                TemplateSignature signature = binding.getSignature();
                if (signature != null && signature.getTemplate() == newOwner) {
                    result = UnexecutableCommand.INSTANCE;
                    break;
                }
                result = this.getEditServiceCommand((EObject)binding, (IEditCommandRequest)new MoveRequest(newOwner, (EObject)binding));
                break;
            }
            case 2: {
                EObject newTarget = request.getNewRelationshipEnd();
                TemplateSignature newSignature = null;
                if (newTarget instanceof TemplateableElement) {
                    newSignature = ((TemplateableElement)newTarget).getOwnedTemplateSignature();
                }
                if (newSignature == null) {
                    result = UnexecutableCommand.INSTANCE;
                    break;
                }
                if (newSignature.getTemplate() == binding.getBoundElement()) {
                    result = UnexecutableCommand.INSTANCE;
                    break;
                }
                result = this.getEditServiceCommand((EObject)binding, (IEditCommandRequest)new SetRequest((EObject)binding, (EStructuralFeature)UMLPackage.Literals.TEMPLATE_BINDING__SIGNATURE, (Object)newSignature));
                break;
            }
            default: {
                result = new UnexecutableCommand((IStatus)new Status(4, "org.eclipse.papyrus.uml.service.types", "Invalid relationship re-orientation direction requested: " + request.getDirection()));
            }
        }
        return result;
    }
}

